/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Product.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.callback.method;

import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusIF;
import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusImpl;
import com.sun.ts.tests.jpa.core.callback.common.GenerictListenerImpl;

import javax.persistence.*;

@Entity
@Table(name="PRODUCT_TABLE")
public class Product extends CallbackStatusImpl 
        implements java.io.Serializable, CallbackStatusIF {
    private String id;
    private String name;
    private double price;
    private int quantity;
    private long partNumber;
    private GenerictListenerImpl callbackImpl = new GenerictListenerImpl();
    
    public Product() {
        super();
    }
    
    @Transient
    public GenerictListenerImpl getCallbackImpl() {
        return callbackImpl;
    }
    public void setCallbackImpl(GenerictListenerImpl callbackImpl) {
        this.callbackImpl = callbackImpl;
    }

    /////////////////////////////////////////////////////////////////////////
    @PrePersist
    private void prePersist() {
        getCallbackImpl().prePersist(this);
    }

    @PostPersist
    private void postPersist() {
        getCallbackImpl().postPersist(this);
    }
    
    
    @PreRemove
    private void preRemove() {
       getCallbackImpl().preRemove(this);
    }
    @PostRemove
    private void postRemove() {
        getCallbackImpl().postRemove(this);
    }
    
    
    @PreUpdate
    private void preUpdate() {
        getCallbackImpl().preUpdate(this);
    }
    @PostUpdate
    private void postUpdate() {
        getCallbackImpl().postUpdate(this);
    }
    
    @PostLoad
    private void postLoad() {
        getCallbackImpl().postLoad(this);
    }
    
    /////////////////////////////////////////////////////////////////////////
   
    @Id
    @Column(name="ID")
    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }
    
    @Column(name="NAME")
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    
    @Column(name="PRICE")
    public double getPrice() {
        return price;
    }
    public void setPrice(double price) {
        this.price = price;
    }
    
    @Column(name="QUANTITY")
    public int getQuantity() {
        return quantity;
    }
    public void setQuantity(int v) {
        this.quantity = v;
    }
    
    @Column(name="PNUM")
    public long getPartNumber() {
        return partNumber;
    }
    public void setPartNumber(long v) {
        this.partNumber = v;
    }
}
