/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.collectiontable;

import com.sun.ts.lib.util.TestUtil;

import javax.persistence.*;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name = "COLTAB")
public class A implements java.io.Serializable {

    @Id
    protected String id;
    protected String name;
    protected int value;

    @ElementCollection
    @CollectionTable(name = "COLTAB_ADDRESS", joinColumns=@JoinColumn(name="A_ID"))
    protected Set<Address> address = new HashSet();

    public A() {
    }

    public A(String id, String name, int value) {
        this.id = id;
        this.name = name;
        this.value = value;
    }

    public Set<Address> getAddress() {
        TestUtil.logTrace("getAddress");
        return address;
    }

    public void setAddress(Set<Address> addr) {
        TestUtil.logTrace("setAddress");
        this.address = addr;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int val) {
        this.value = val;
    }
}
