/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.core.annotations.access.mappedsc;

import javax.persistence.*;
import java.sql.Date;

/*
 * Employee as mapped superclass, which can be concrete or abstract.
 * Mapping may be overriden by subclass entities with annotation or descriptor.
 */

@MappedSuperclass()
@Access(AccessType.PROPERTY)
public abstract class Employee extends AbstractPersonnel {

    private  int	     id;
    private  String	     firstName;
    private  String	     lastName;
    private  Date	     hireDate;

   /** the project this Employee leads */
    protected Project project;
 
   /** the department this Employee belongs to */
    protected Department department;

    protected Employee() {}
    
    protected Employee(int id, String firstName, String lastName, Date hireDate) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.hireDate = (Date) hireDate.clone();
    }
    
   // ===========================================================
   // getters and setters for the state fields

    @Id
    @Column(name="IDxx")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="FIRSTNAMExx")
    public String getFirstName() {
        return firstName;
    }
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAMExx")
    public String getLastName() {
        return lastName;
    }
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="HIREDATExx")
    public Date getHireDate() {
        return hireDate;
    }
    public void setHireDate(Date hireDate) {
        this.hireDate = hireDate;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    @OneToOne
    @JoinColumn(name="FK_PROJECT")
    public Project getProject() {
        return project;
    }
    public void setProject(Project project) {
        this.project = project;
    }

}

