/*
 * Copyright (c) 2007, 2013, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.common;

import com.sun.ts.lib.util.TestUtil;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;

public class DriverManagerConnection  {

  public Connection getConnection(Properties p) throws Exception{
    String dbUrl, dbUser, dbPassword, dbDriver;
    dbUrl = dbUser = dbPassword = dbDriver = null;

    dbUrl = p.getProperty("javax.persistence.jdbc.url","");
    dbUser = p.getProperty("javax.persistence.jdbc.user","");
    dbPassword = p.getProperty("javax.persistence.jdbc.password","");
    dbDriver = p.getProperty("javax.persistence.jdbc.driver","");

    TestUtil.logTrace("Url : " + dbUrl);
    TestUtil.logTrace("Username  : " + dbUser);
    TestUtil.logTrace("Password  : " + dbPassword);
    TestUtil.logTrace("Driver    : " + dbDriver);

    TestUtil.logTrace("About to load the driver class");
    Class.forName(dbDriver);
    TestUtil.logMsg("Successfully loaded the driver class");

    TestUtil.logTrace("About to make the DB connection");
    Connection con=DriverManager.getConnection(dbUrl, dbUser, dbPassword);
    TestUtil.logMsg("Made the JDBC connection to the DB");

    return con;
  }

}
