/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR273XClient2.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R273X;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

public class W2JRLR273XClient2 extends SOAPClient {
    public W2JRLR273XClient2(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        this(webServerHost, webServerPort, mode, null);
    }

    public W2JRLR273XClient2(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://w2jrlr273Xtestservice.org/W2JRLR273XTestService.wsdl");
        stubContext.setService("W2JRLR273XTestService");
        stubContext.setPort("W2JRLR273XTest2Port");
        stubContext.setEndpointInterface(W2JRLR273XTest2.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jrlr273X.endpoint.2";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jrlr273X.wsdlloc.1";
    }

    public FooBar echoFooBar(FooBar fb) throws Exception {
        FooBar fb1 = ((W2JRLR273XTest2)stubContext.getStub()).echoFooBar(fb);
        return fb1;
    }
}
