/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.document.literal.R2707;

import java.util.Properties;

import javax.xml.ws.*;
import com.sun.javatest.Status;
import com.sun.ts.lib.harness.*;

import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;

public class Client extends ServiceEETest {
    /**
     * The string to be echoed.
     */
    private static final String STRING = "R2707";
    
    /**
     * The client.
     */
    private W2JDLR2707Client client;

    
    static W2JDLR2707TestService service = null;
    
    /**
     * Test entry point.
     * 
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client client = new Client();
        Status status = client.run(args, System.out, System.err);
        status.exit();
    }

    
    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws Fault
     */
    public void setup(String[] args, Properties properties) throws Fault {
        client = (W2JDLR2707Client)ClientFactory.getClient(W2JDLR2707Client.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup() {
        logMsg("cleanup");
    }

    /**
     * @testName: testUseAttributeDefaulting
     *
     * @assertion_ids: WSI:SPEC:R2707
     *
     * @test_Strategy: The supplied WSDL, containg a soap:body, soapbind fault,
     * soapbind:header or soapbind:headerfault element without the use="literal"
     * attribute has been used by the WSDL-to-Java tool to generate an end point.
     * If the tool works correctly, the end-point has been built and deployed
     * so it should simply be reachable.
     *
     * @throws Fault
     */
    public void testUseAttributeDefaulting() throws Fault {
        String result;
        try {
            result = client.echoString(STRING);
        } catch (Exception e) {
            throw new Fault("Unable to invoke echoString operation (BP-R2707)", e);
        }
        if (!STRING.equals(result)) {
            throw new Fault("echoString operation returns '" + result + "' in stead of '" + STRING + "' (BP-R2707)");
        }
    }
}
