/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: AddNumbersImpl.java 51075 2003-03-27 10:44:21Z lschwenk $
 */

package com.sun.ts.tests.jaxws.wsa.j2w.document.literal.epr;

import javax.annotation.Resource;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import javax.xml.ws.BindingType;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

@WebService(
    name="AddNumbers", 
    portName="AddNumbersPort", 
    targetNamespace="http://foobar.org/", 
    serviceName="AddNumbersService"
)
@BindingType(value=SOAPBinding.SOAP11HTTP_BINDING)
@Addressing(enabled=true,required=true)
public class AddNumbersImpl {
	
    @Resource
    WebServiceContext wsc;

    public W3CEndpointReference getW3CEPR1() {
	System.out.println("wsc="+wsc);
        return (W3CEndpointReference) wsc.getEndpointReference();
    }

    public W3CEndpointReference getW3CEPR2() {
	System.out.println("wsc="+wsc);
        return (W3CEndpointReference) wsc.getEndpointReference(
			javax.xml.ws.wsaddressing.W3CEndpointReference.class);
    }

    public int doAddNumbers(int number1, int number2) {
        return number1 + number2;
    }
}
