/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.apache.tools.ant.Task;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DescriptorHandler
extends HandlerBase {
    protected Task owningTask;
    protected String publicId = null;
    protected String currentElement = null;
    protected int parseState = 0;
    protected String currentText = null;
    protected Hashtable fileDTDs = new Hashtable();
    protected Hashtable resourceDTDs = new Hashtable();
    protected Hashtable urlDTDs = new Hashtable();
    protected File srcDir;
    protected String name = null;
    protected Hashtable files = null;

    public DescriptorHandler(Task task, File srcDir) {
        this.owningTask = task;
        this.srcDir = srcDir;
    }

    public void startDocument() throws SAXException {
        this.files = new Hashtable(10, 1.0f);
        this.currentElement = null;
    }

    public void startElement(String name, AttributeList attrs) throws SAXException {
        this.currentElement = name;
        this.currentText = "";
    }

    public void registerDTD(String publicId, String location) {
        if (location == null) {
            return;
        }
        File fileDTD = new File(location);
        if (fileDTD.exists()) {
            if (publicId != null) {
                this.fileDTDs.put(publicId, fileDTD);
                this.owningTask.log("Mapped publicId " + publicId + " to file " + fileDTD, 3);
            }
            return;
        }
        if (this.getClass().getResource(location) != null && publicId != null) {
            this.resourceDTDs.put(publicId, location);
            this.owningTask.log("Mapped publicId " + publicId + " to resource " + location, 3);
        }
        try {
            if (publicId != null) {
                URL urldtd = new URL(location);
                this.urlDTDs.put(publicId, urldtd);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputStream is;
        String dtdResourceName;
        this.publicId = publicId;
        File dtdFile = (File)this.fileDTDs.get(publicId);
        if (dtdFile != null) {
            try {
                this.owningTask.log("Resolved " + publicId + " to local file " + dtdFile, 3);
                return new InputSource(new FileInputStream(dtdFile));
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
        if ((dtdResourceName = (String)this.resourceDTDs.get(publicId)) != null && (is = this.getClass().getResourceAsStream(dtdResourceName)) != null) {
            this.owningTask.log("Resolved " + publicId + " to local resource " + dtdResourceName, 3);
            return new InputSource(is);
        }
        URL dtdUrl = (URL)this.urlDTDs.get(publicId);
        if (dtdUrl != null) {
            try {
                InputStream is2 = dtdUrl.openStream();
                this.owningTask.log("Resolved " + publicId + " to url " + dtdUrl, 3);
                return new InputSource(is2);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.owningTask.log("Could not resolve ( publicId: " + publicId + ", systemId: " + systemId + ") to a local entity", 2);
        return null;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText = this.currentText + new String(ch, start, length);
    }

    public Hashtable getFiles() {
        return this.files == null ? new Hashtable() : this.files;
    }

    public String getName() {
        return this.name;
    }
}

