/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.config;

import com.sun.ts.tests.jaspic.tssv.config.TSClientAuthConfig;
import com.sun.ts.tests.jaspic.tssv.config.TSServerAuthConfig;
import com.sun.ts.tests.jaspic.tssv.util.AuthDataCallbackHandler;
import com.sun.ts.tests.jaspic.tssv.util.TSFileHandler;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import com.sun.ts.tests.jaspic.tssv.util.TSXMLFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ServerAuthConfig;

public class TSAuthConfigProvider
implements AuthConfigProvider {
    private static TSLogger logger = null;
    private static Map properties = null;
    private HashMap clientAuthConfigMap = new HashMap();
    private HashMap serverAuthConfigMap = new HashMap();

    public TSAuthConfigProvider(Map props, AuthConfigFactory factory) {
        properties = props;
        if (factory != null) {
            factory.registerConfigProvider((AuthConfigProvider)this, null, null, "TSAuthConfig Provider self registration");
        }
        if (logger == null) {
            TSAuthConfigProvider.initializeTSLogger();
        }
    }

    public TSAuthConfigProvider(Map props, AuthConfigFactory factory, TSLogger tsLogger) {
        properties = props;
        if (factory != null) {
            factory.registerConfigProvider((AuthConfigProvider)this, null, null, "TSAuthConfig Provider self registration");
        }
        if (tsLogger != null) {
            logger = tsLogger;
        }
    }

    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        String logStr = "TSAuthConfigProvider.getClientAuthConfig called for layer=" + layer + " : appContext=" + appContext;
        logger.log(Level.INFO, logStr);
        try {
            if (handler == null) {
                handler = new AuthDataCallbackHandler();
            } else {
                System.out.println("Received callbackHandler =" + handler.getClass().getName());
                handler = new AuthDataCallbackHandler();
            }
            TSClientAuthConfig clientAuthConfig = new TSClientAuthConfig(layer, appContext, handler, properties, logger);
            this.clientAuthConfigMap.put(layer + appContext, clientAuthConfig);
            return clientAuthConfig;
        }
        catch (Exception e) {
            throw new AuthException(e.getMessage());
        }
    }

    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        String logStr = "TSAuthConfigProvider.getServerAuthConfig called for layer=" + layer + " : appContext=" + appContext;
        logger.log(Level.INFO, logStr);
        try {
            if (!layer.equals("HttpServlet") && handler == null) {
                handler = new AuthDataCallbackHandler();
            } else if (layer.equals("HttpServlet") && handler == null) {
                String msg = "FAILURE: layer=" + layer + " appContext=" + appContext;
                msg = msg + " getServerAuthConfig() received CallbackHandler=null";
                logger.log(Level.INFO, msg);
            }
            TSServerAuthConfig serverAuthConfig = new TSServerAuthConfig(layer, appContext, handler, properties, logger);
            this.serverAuthConfigMap.put(layer + appContext, serverAuthConfig);
            return serverAuthConfig;
        }
        catch (Exception e) {
            throw new AuthException(e.getMessage());
        }
    }

    public void refresh() {
    }

    private static void initializeTSLogger() {
        String logFileLocation = null;
        if (logger != null) {
            return;
        }
        try {
            logFileLocation = System.getProperty("log.file.location");
            if (logFileLocation == null) {
                throw new RuntimeException("log.file.location not set");
            }
            logger = TSLogger.getTSLogger("jsr196");
            boolean appendMode = true;
            TSFileHandler fileHandler = new TSFileHandler(logFileLocation + "/" + "TSSVLog.txt", appendMode);
            fileHandler.setFormatter(new TSXMLFormatter());
            logger.addHandler(fileHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("TSLogger Initialization failed", e);
        }
    }
}

