/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: JAXRSClient.java 75067 2017-06-14 15:43:37Z jsupol $ 
 */

package com.sun.ts.tests.jaxrs.jaxrs21.spec.classsubresourcelocator;

import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
/**
 * @since 2.1
 */
public class JAXRSClient extends JaxrsCommonClient {

	private static final long serialVersionUID = 21L;

	public JAXRSClient() {
		setContextRoot("/jaxrs_jaxrs21_spec_classsubresourcelocator_web/resource");
	}

	/**
	 * Entry point for different-VM execution. It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		JAXRSClient c = new JAXRSClient();
		c.run(args);
	}

	/* Run test */
	/*
	 * @testName: subResourceLocatorAsClassTest
	 * @assertion_ids: JAXRS:SPEC:125;
	 * @test_Strategy: 
	 */
	public void subResourceLocatorAsClassTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.GET, "sub"));		
		setProperty(Property.SEARCH_STRING, "OK");		
		invoke();
	}


}
