/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: SecondResponseFilter.java 69965 2013-02-13 12:02:10Z supol $
 */

package com.sun.ts.tests.jaxrs.ee.rs.container.responsecontext;

import java.lang.annotation.Annotation;

import javax.annotation.Priority;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(100)
// reverse order, should be second
public class SecondResponseFilter extends TemplateFilter {
	@Override
	protected void operationMethodNotFound(String operation) {
		// the check is to apply on ResponseFilter only
		// here, it is usually not found.
	}

	public void getHeadersIsMutable() {
		MultivaluedMap<String, Object> headers = responseContext.getHeaders();
		if (assertTrue(headers.containsKey(HEADER), HEADER,
				"header is not in header map"))
			return;
		setEntity(HEADER + " found as expected");
	}

	public void setEntity() {
		MediaType type = responseContext.getMediaType();
		if (assertTrue(MediaType.APPLICATION_SVG_XML_TYPE.equals(type),
				"Unexpected mediatype", type))
			return;

		Annotation[] annotations = responseContext.getEntityAnnotations();
		for (Annotation annotation : annotations) {
			Class<?> clazz = annotation.annotationType();
			if (assertTrue(clazz == Provider.class
					|| clazz == Priority.class, "Annotation", clazz,
					"was unexpected"))
				return;
		}
	}
}
