/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: CollectionWriter.java 70710 2013-03-15 11:47:37Z supol $
 */
package com.sun.ts.tests.jaxrs.ee.resource.java2entity;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import com.sun.ts.tests.jaxrs.common.AbstractMessageBodyRW;

/**
 * If isWritable arguments are passed according to the spec, writes OK,
 * otherwise IncorrectCollectionWriter writes ERROR
 */
@Provider
public class CollectionWriter extends AbstractMessageBodyRW implements
		MessageBodyWriter<Collection<?>> {
	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		String path = getPathValue(annotations);
		// Return type : Other
		if (path.equalsIgnoreCase(type.getSimpleName()))
			return checkOther(type, genericType);
		else if (path.equalsIgnoreCase("response/linkedlist"))
			return checkResponseNongeneric(type, genericType);
		else if (path.equalsIgnoreCase("response/genericentity/linkedlist"))
			return checkGeneric(type, genericType);
		else if (path.equalsIgnoreCase("genericentity/linkedlist"))
			return checkGeneric(type, genericType);
		return false;
	}

	private static boolean checkOther(Class<?> type, Type genericType) {
		if (!(genericType instanceof ParameterizedType))
			return false;
		ParameterizedType pType = (ParameterizedType) genericType;
		boolean ok = pType.getRawType().equals(LinkedList.class);
		ok &= pType.getActualTypeArguments()[0].equals(String.class);
		return ok;
	}

	private static boolean checkResponseNongeneric(Class<?> type,
			Type genericType) {
		boolean ok = genericType.equals(LinkedList.class);
		ok &= type.equals(LinkedList.class);
		return ok;
	}

	private static boolean checkGeneric(Class<?> type, Type genericType) {
		if (ParameterizedType.class.isInstance(genericType))
			genericType = ((ParameterizedType) genericType).getRawType();		
		boolean ok = genericType.getClass().equals(List.class)
				|| genericType.equals(LinkedList.class);
		ok &= type.equals(LinkedList.class);
		return ok;
	}

	@Override
	public long getSize(Collection<?> t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return Response.Status.OK.name().length();
	}

	@Override
	public void writeTo(Collection<?> t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		entityStream.write(Response.Status.OK.name().getBytes());
	}

}
