/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.freebxml.omar.common.UUIDFactory;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;

public class Utility {
    private static HashMap tableNameMap = new HashMap();
    private static HashMap columnNameMap;
    public static final String REGEXP_URN = "^urn:[a-zA-Z0-9][a-zA-Z0-9-]{1,31}:([a-zA-Z0-9()+,.:=@;$_!*'-]|%[0-9A-Fa-f]{2})+$";
    private static Utility instance;
    static /* synthetic */ Class class$org$freebxml$omar$common$Utility;

    protected Utility() {
    }

    public StringBuffer getStringBufferFromInputStream(InputStream is) throws IOException {
        int buflen = 1024;
        char[] chars = new char[buflen + 1];
        StringBuffer strBuf = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int charsRead = 0;
        while ((charsRead = br.read(chars, 0, buflen)) != -1) {
            strBuf.append(chars, 0, charsRead);
        }
        return strBuf;
    }

    public boolean isValidRegistryId(String id) {
        boolean isValid = false;
        isValid = this.isValidURN(id);
        return isValid;
    }

    public String createId() {
        String id = "urn:uuid:" + UUIDFactory.getInstance().newUUID().toString();
        return id;
    }

    public String stripId(String id) {
        if (id != null) {
            id = id.startsWith("urn:uuid:") ? id.substring(9).trim() : id.replaceAll(":", "_");
        }
        return id;
    }

    public boolean isValidURN(String urn) {
        boolean isValidURN = false;
        if (urn != null) {
            isValidURN = Pattern.matches(REGEXP_URN, urn);
        }
        return isValidURN;
    }

    public boolean isValidURI(String uRI) {
        URL uRL = null;
        try {
            URI _uri = new URI(uRI);
            uRL = new URL(uRI);
        }
        catch (URISyntaxException e) {
            return false;
        }
        catch (MalformedURLException e) {
            return true;
        }
        if (uRL.getProtocol().equalsIgnoreCase("http")) {
            try {
                HttpURLConnection httpUrlConn = (HttpURLConnection)uRL.openConnection();
                int responseCode = httpUrlConn.getResponseCode();
                return responseCode >= 200 && responseCode <= 299;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public String mapTableName(RegistryObjectType ro) {
        Class<?> clazz = ro.getClass();
        String className = clazz.getName();
        if ((className = className.substring(className.lastIndexOf(".") + 1)).endsWith("Impl")) {
            className = className.substring(0, className.length() - 4);
        }
        return this.mapTableName(className);
    }

    public String mapTableName(String name) {
        String newName = (String)tableNameMap.get(name.toLowerCase().trim());
        if (newName == null) {
            newName = name;
        }
        return newName;
    }

    public String mapColumnName(String name) {
        String newName = (String)columnNameMap.get(name.toLowerCase().trim());
        if (newName == null) {
            newName = name;
        }
        return newName;
    }

    public String getClassNameNoPackage(Object obj) {
        Class<?> clazz = obj.getClass();
        return this.getClassNameNoPackage(clazz);
    }

    public String getClassNameNoPackage(Class clazz) {
        String className = clazz.getName();
        int index = className.lastIndexOf(46);
        if (index >= 0) {
            className = className.substring(index + 1, className.length());
        }
        return className;
    }

    public static boolean containsWhiteSpacesOnly(String str) {
        boolean whiteSpaceOnly = false;
        String[] strArr = str.split("[^\\s]");
        if (str == null || str.length() == 0 || str.split("[^\\s]").length <= 1) {
            whiteSpaceOnly = true;
        }
        return whiteSpaceOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Utility getInstance() {
        if (instance == null) {
            Class clazz = class$org$freebxml$omar$common$Utility == null ? (class$org$freebxml$omar$common$Utility = Utility.class$("org.freebxml.omar.common.Utility")) : class$org$freebxml$omar$common$Utility;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new Utility();
                }
            }
        }
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tableNameMap.put("user", "user_");
        tableNameMap.put("name", "name_");
        tableNameMap.put("classificationscheme", "ClassScheme");
        tableNameMap.put("concept", "ClassificationNode");
        columnNameMap = new HashMap();
        columnNameMap.put("number", "number_");
        columnNameMap.put("name", "name_");
        columnNameMap.put("user", "user_");
        columnNameMap.put("timestamp", "timestamp_");
        instance = null;
    }
}

