/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.NamedNodeMap;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.xml.XmlElement;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Element;

public class XMLElement
extends Node {
    private static final long serialVersionUID = 5616690634173934926L;

    public HTMLCollection jsxFunction_selectNodes(String expression) {
        HTMLCollection collection = new HTMLCollection(this);
        collection.init(this.getDomNodeOrDie(), expression);
        return collection;
    }

    public Object jsxFunction_selectSingleNode(String expression) {
        HTMLCollection collection = this.jsxFunction_selectNodes(expression);
        if (collection.jsxGet_length() > 0) {
            return collection.get(0, (Scriptable)collection);
        }
        return null;
    }

    public String jsxGet_tagName() {
        return ((XmlElement)this.getDomNodeOrDie()).getTagName();
    }

    public Object jsxGet_attributes() {
        Map<String, DomAttr> attributes = ((XmlElement)this.getDomNodeOrDie()).getAttributesMap();
        ArrayList<ScriptableObject> list = new ArrayList<ScriptableObject>();
        for (DomAttr attr : attributes.values()) {
            list.add(attr.getScriptObject());
        }
        return new NamedNodeMap((XmlElement)this.getDomNodeOrDie());
    }

    public String jsxFunction_getAttribute(String attributeName) {
        String value = ((XmlElement)this.getDomNodeOrDie()).getAttributeValue(attributeName);
        if (value == XmlElement.ATTRIBUTE_NOT_DEFINED) {
            return null;
        }
        return value;
    }

    public void jsxFunction_setAttribute(String name, String value) {
        ((XmlElement)this.getDomNodeOrDie()).setAttributeValue(name, value);
    }

    public Object jsxFunction_getElementsByTagName(String tagName) {
        DomNode domNode = this.getDomNodeOrDie();
        HTMLCollection collection = new HTMLCollection(this);
        String xpath = ".//" + tagName;
        collection.init(domNode, xpath);
        return collection;
    }

    public Object jsxFunction_getAttributeNode(String name) {
        Map<String, DomAttr> attributes = ((XmlElement)this.getDomNodeOrDie()).getAttributesMap();
        for (DomAttr attr : attributes.values()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getScriptObject();
        }
        return null;
    }

    public String jsxGet_text() {
        StringBuilder buffer = new StringBuilder();
        this.toText(this.getDomNodeOrDie(), buffer);
        return buffer.toString();
    }

    private void toText(DomNode node, StringBuilder buffer) {
        switch (node.getNodeType()) {
            case 10: 
            case 12: {
                return;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                buffer.append(node.getNodeValue());
                break;
            }
        }
        for (DomNode child : node.getChildren()) {
            switch (child.getNodeType()) {
                case 1: {
                    this.toText(child, buffer);
                    break;
                }
                case 3: 
                case 4: {
                    buffer.append(child.getNodeValue());
                    break;
                }
            }
        }
    }

    public Object jsxFunction_getElementsByTagNameNS(String namespaceURI, String localName) {
        String xpath;
        DomNode domNode = this.getDomNodeOrDie();
        HTMLCollection collection = new HTMLCollection(this);
        if (namespaceURI.equals("*")) {
            xpath = ".//" + localName;
        } else {
            String prefix = XmlUtil.lookupPrefix((XmlElement)domNode, namespaceURI);
            xpath = ".//" + prefix + ':' + localName;
        }
        collection.init(domNode, xpath);
        return collection;
    }

    public boolean jsxFunction_hasAttribute(String name) {
        return ((XmlElement)this.getDomNodeOrDie()).hasAttribute(name);
    }

    public String jsxGet_xml() {
        OutputFormat format = new OutputFormat();
        format.setOmitXMLDeclaration(true);
        StringWriter writer = new StringWriter();
        XMLSerializer serializer = new XMLSerializer(format);
        serializer.setOutputCharStream((Writer)writer);
        try {
            serializer.serialize((Element)((XmlElement)this.getDomNodeOrDie()));
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: failed to serialize", e);
        }
        return writer.toString();
    }

    public String getClassName() {
        return "Element";
    }
}

