/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Event
extends SimpleScriptable {
    static final String KEY_CURRENT_EVENT = "Event#current";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_CHANGE = "change";
    public static final String TYPE_LOAD = "load";
    public static final String TYPE_UNLOAD = "unload";
    public static final String TYPE_FOCUS = "focus";
    public static final String TYPE_FOCUS_IN = "focusin";
    public static final String TYPE_FOCUS_OUT = "focusout";
    public static final String TYPE_BLUR = "blur";
    public static final String TYPE_KEY_DOWN = "keydown";
    public static final String TYPE_KEY_PRESS = "keypress";
    public static final String TYPE_KEY_UP = "keyup";
    public static final String TYPE_RESET = "reset";
    public static final String TYPE_BEFORE_UNLOAD = "beforeunload";
    public static final String TYPE_DOM_DOCUMENT_LOADED = "DOMContentLoaded";
    public static final String TYPE_PROPERTY_CHANGE = "propertychange";
    public static final short CAPTURING_PHASE = 1;
    public static final short AT_TARGET = 2;
    public static final short BUBBLING_PHASE = 3;
    private static final long serialVersionUID = 4050485607908455730L;
    private Object srcElement_;
    private Object target_;
    private Object currentTarget_;
    private String type_;
    private Object keyCode_;
    private boolean shiftKey_;
    private boolean ctrlKey_;
    private boolean altKey_;
    private String propertyName_;
    private boolean stopPropagation_;
    private Object returnValue_;
    private boolean preventDefault_;
    private short eventPhase_;
    private boolean bubbles_ = true;
    private boolean cancelable_ = true;
    private long timeStamp_ = System.currentTimeMillis();

    public Event(DomNode domNode, String type) {
        this(domNode, type, false, false, false);
    }

    public Event(DomNode domNode, String type, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        ScriptableObject target = domNode.getScriptObject();
        this.srcElement_ = target;
        this.target_ = target;
        this.currentTarget_ = target;
        this.type_ = type;
        this.shiftKey_ = shiftKey;
        this.ctrlKey_ = ctrlKey;
        this.altKey_ = altKey;
        this.keyCode_ = Context.getUndefinedValue();
        this.setParentScope((Scriptable)((SimpleScriptable)target));
        this.setPrototype(this.getPrototype(((Object)((Object)this)).getClass()));
        this.setDomNode(domNode, false);
    }

    public Event(DomNode domNode, String type, int keyCode, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        this(domNode, type, shiftKey, ctrlKey, altKey);
        this.keyCode_ = new Integer(keyCode);
    }

    public static Event createPropertyChangeEvent(DomNode domNode, String propertyName) {
        Event event = new Event(domNode, TYPE_PROPERTY_CHANGE);
        event.propertyName_ = propertyName;
        return event;
    }

    public Event() {
    }

    void startFire() {
        Context.getCurrentContext().putThreadLocal((Object)KEY_CURRENT_EVENT, (Object)this);
    }

    void endFire() {
        Context.getCurrentContext().removeThreadLocal((Object)KEY_CURRENT_EVENT);
    }

    public Object jsxGet_srcElement() {
        return this.srcElement_;
    }

    public void jsxSet_srcElement(Object srcElement) {
        this.srcElement_ = srcElement;
    }

    public Object jsxGet_target() {
        return this.target_;
    }

    public void setTarget(Object target) {
        this.target_ = target;
    }

    public Object jsxGet_currentTarget() {
        return this.currentTarget_;
    }

    public void setCurrentTarget(Scriptable target) {
        this.currentTarget_ = target;
    }

    public String jsxGet_type() {
        return this.type_;
    }

    public void setEventType(String eventType) {
        this.type_ = eventType;
    }

    public long jsxGet_timeStamp() {
        return this.timeStamp_;
    }

    public Object jsxGet_keyCode() {
        return this.keyCode_;
    }

    public boolean jsxGet_shiftKey() {
        return this.shiftKey_;
    }

    protected void setShiftKey(boolean shiftKey) {
        this.shiftKey_ = shiftKey;
    }

    public boolean jsxGet_ctrlKey() {
        return this.ctrlKey_;
    }

    protected void setCtrlKey(boolean ctrlKey) {
        this.ctrlKey_ = ctrlKey;
    }

    public boolean jsxGet_altKey() {
        return this.altKey_;
    }

    protected void setAltKey(boolean altKey) {
        this.altKey_ = altKey;
    }

    public int jsxGet_eventPhase() {
        return this.eventPhase_;
    }

    public void setEventPhase(short phase) {
        if (phase != 1 && phase != 2 && phase != 3) {
            throw new IllegalArgumentException("Illegal phase specified: " + phase);
        }
        this.eventPhase_ = phase;
    }

    public boolean jsxGet_bubbles() {
        return this.bubbles_;
    }

    public boolean jsxGet_cancelable() {
        return this.cancelable_;
    }

    public boolean jsxGet_cancelBubble() {
        return this.stopPropagation_;
    }

    public void jsxSet_cancelBubble(boolean newValue) {
        this.stopPropagation_ = newValue;
    }

    public void jsxFunction_stopPropagation() {
        this.stopPropagation_ = true;
    }

    public boolean isPropagationStopped() {
        return this.stopPropagation_;
    }

    public Object jsxGet_returnValue() {
        return this.returnValue_;
    }

    public String jsxGet_propertyName() {
        return this.propertyName_;
    }

    public void jsxSet_returnValue(Object returnValue) {
        this.returnValue_ = returnValue;
    }

    public void jsxFunction_initEvent(String type, boolean bubbles, boolean cancelable) {
        this.type_ = type;
        this.bubbles_ = bubbles;
        this.cancelable_ = cancelable;
    }

    public void jsxFunction_preventDefault() {
        this.preventDefault_ = true;
    }

    public boolean isPreventDefault() {
        return this.preventDefault_;
    }

    public void copyPropertiesFrom(Event event) {
        this.srcElement_ = event.srcElement_;
        this.target_ = event.target_;
        this.currentTarget_ = event.currentTarget_;
        this.type_ = event.type_;
        this.keyCode_ = event.keyCode_;
        this.shiftKey_ = event.shiftKey_;
        this.ctrlKey_ = event.ctrlKey_;
        this.altKey_ = event.altKey_;
        this.stopPropagation_ = event.stopPropagation_;
        this.returnValue_ = event.returnValue_;
        this.eventPhase_ = event.eventPhase_;
        this.bubbles_ = event.bubbles_;
        this.cancelable_ = event.cancelable_;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Event ");
        buffer.append(this.jsxGet_type());
        buffer.append(" (");
        buffer.append("Current Target: ");
        buffer.append(this.currentTarget_);
        buffer.append(");");
        return buffer.toString();
    }
}

