/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.MimeUtility;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>decodeText()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 * 
 *		Decode "unstructured" headers. <p>
 * api2test: public static String decodeText(String)  <p>
 *
 * how2test: Call API "unstructured" header strings, if outputs message
 *	     then testcase passes, otherwise it fails.
 */

public class decodeText_Test extends MailTest {

public String[] datim = { "=?ISO-8859-1?B?SWYgeW91IGNhbiByZWFkIHRoaXMgeW8=?=",
		          "=?ISO-8859-2?B?dSB1bmRlcnN0YW5kIHRoZSBleGFtcGxlLg==?= Congrats!",
			  "Hello World	",
			  "  Hello",
			  "        World	",
			  "=?ISO-8859-1?Q?Andr=E9?= Pirard <PIRARD@vm1.ulg.ac.be>",
			  "=?ISO-8859-1?Q?Keld_J=F8rn_Simonsen?= <keld@dkuug.dk>",
			  "=?ISO-8859-1?Q?Patrik_F=E4ltstr=F6m?= <paf@nada.kth.se>",
			  "=?iso-8859-8?b?7eXs+SDv4SDp7Oj08A==?=",
			  "=?ISO-2022-JP?B?GyRCQmdCPCEhWEYwbE86GyhK?=",
			  "[mizuki 1007] Re: Hajimemasite!!",
			  "Kazuyuki Murata <hiroko@hamakko.or.jp>",
			  "[mizuki 1009] =?ISO-2022-JP?B?GyRCJUYlbCVTPVAxaT5wSnMbKEI=?="
			};

    public static void main( String argv[] )
    {
        decodeText_Test test = new decodeText_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	// parse command-line options
	parseArgs(argv);

        out.println("\nTesting class MimeUtility: decodeText(String);");

        try {
	  // BEGIN UNIT TEST:

	     for( int k = 0; k < datim.length; k++ )
	     {
	         out.println("UNIT TEST "+ k +":  decodeText("+datim[k]+")");

	         out.println("Decoded text = "+ MimeUtility.decodeText(datim[k]));
		 out.println("\nUNIT TEST "+ k +": passed");
	         out.println("----------------------------------------");
	     }
	  // END UNIT TEST:
             checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
