/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.MimeBodyPart;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>setContent()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		Set the content as a Multipart object. <p>
 * api2test: public void setContent(Multipart)  <p>
 *
 * how2test: Call API, then check the type of java object returned. We test <p>
 *	     for 'string','multipart', and non-null. The testcases passes if the api <p>
 *	     returns any one of these object types, otherwise we mark as it failing.
 */

public class setContent_Test extends MailTest {

    public static void main( String argv[] )
    {
        setContent_Test test = new setContent_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class MimeBodyPart: setContent()\n");

        try {
          // Create a MimeBodyPart object
	     MimeBodyPart bp = new MimeBodyPart();

             if( bp == null )
                 return Status.failed("Failed to create MimeBodyPart object!");

          // Create a MultiPart object
             Multipart mp = new MimeMultipart();

             if( mp == null )
                 return Status.failed("Failed to create Multipart object!");

	  // BEGIN UNIT TEST:
	     out.println("UNIT TEST 1:  setContent(Multipart)");

	     // Set the content
	     bp.setContent(mp); 	// API TEST

	     out.println("UNIT TEST 1:  passed\n");
	  // END UNIT TEST:
          // BEGIN UNIT TEST:
             out.println("UNIT TEST 2:  setContent(Object, String)");
	     Object ob = bp.getContent();

             // Set the content
             bp.setContent(ob, "application/x-foobar");         // API TEST

             out.println("UNIT TEST 2:  passed\n");
          // END UNIT TEST:

	     checkStatus();
        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
