/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.InternetHeaders;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>setHeaders()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *	     Add a header with the specified name and value to the end of the header list. <p>
 * api2test: public void setHeader(String, String); <p>
 *
 * how2test: Call API with various arguments, then verify by calling getHeader() api and
 *	     comparing the 'set/'get' values. If they are equal then testcase passes,
 *	     otherwise it fails.
 */

public class setHeader_Test extends MailTest {

    public static String[] head = { "Date:","From:","Subject:","To:","Cc" };
    public static String[] value = { "Fri Dec  5 17:48:51 PST 1997-1998","test#%&@sun.com","JavaMail testing","Javamail@sun.com","xyz@aol.com" };
    
    public static void main( String argv[] )
    {
        setHeader_Test test = new setHeader_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class InternetHeaders: setHeader(String, String)\n");

        try {
	  // create internetheader object
	     InternetHeaders ih = new InternetHeaders();

	     if( ih == null ) {
		 return Status.failed("Warning: failed to created InternetHeaders object");
	     }
	  // BEGIN UNIT TEST:
	  
	     // add header 'name|value' pairs
	     for( int i = 0; i < 5; i++ )
	     {
		  ih.addHeader(head[i], value[i]);
	     }
	     
	     // set header 'name|value' pairs
	     for( int i = 0; i < 5; i++ )
	     {
		  ih.setHeader(head[i], value[i]);	// API TEST
	     }
	     
	     // compare the set and get 'value'
	     for( int j = 0; j < 5; j++ )
	     {
		  out.println("UNIT TEST "+ (j+1) +":  setHeader("+ head[j] +", "+ value[j] +")");
		  
		  String[] header = ih.getHeader(head[j]);
		  
		  if( (header[0]).equals(value[j]) )
		       out.println("UNIT TEST "+ (j+1) +": passed");
		  else {
			out.println("UNIT TEST "+ (j+1) +": FAILED");
			errors++;
		  }
	     }
	  // END UNIT TEST:
             checkStatus();

        } catch ( Exception e ) {
             handlException(e);
        }
	return status;
     }
}
