/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Session;

import java.util.*;
import java.io.*;
import javax.mail.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>setPasswordAuthentication()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		Save a PasswordAuthentication for this (store or transport) URLName. <p>
 * api2test: public void setPasswordAuthentication(URLName, PasswordAuthentication)  <p>
 *
 * how2test: Call this API with the argument of returned object.
 *	     If its a PasswordAuthentication then this testcase passes.
 */

public class setPasswdAuthen_Test extends MailTest {

    public static void main( String argv[] )
    {
        setPasswdAuthen_Test test = new setPasswdAuthen_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Session: setPasswordAuthentication(URLName, PasswordAuthentication)\n");

        try {
           // Get Session object
              Session session = Session.getInstance(properties, null);

	   // Create a URLName object
              URLName url = new URLName(protocol,host,0,mailbox,null,null);

              if( url == null )
                  return Status.failed("Failed to create a URLName object!");

	   // Initialize a new PasswordAuthentication
	      PasswordAuthentication pwa = new PasswordAuthentication(user, password);

              if( pwa == null )
                  return Status.failed("Failed to initialize a PasswordAuthentication object!");

           // BEGIN UNIT TEST 1:
              out.println("UNIT TEST 1:  setPasswordAuthentication(URLName, PasswordAuthentication)");

              session.setPasswordAuthentication(url, pwa);  // API TEST
	      PasswordAuthentication pa = session.getPasswordAuthentication(url);

              if( pa != null ) {
		  out.println("User name is "+ pa.getUserName());
		  out.println("User password is "+ pa.getPassword());
                  out.println("UNIT TEST 1: passed");
	      } else {
		    out.println("UNIT TEST 1: FAILED.\n");
		    errors++;
	      }
           // END UNIT TEST 1:
	      checkStatus();

        } catch ( Exception e ) {
	      handlException(e);
        }
	return status;
     }
}
