/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Folder;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getStore()</strong> API.
 * It does this by invoking the api under test and then checking
 * the type of the returned object.	<p>
 *
 *		Returns the Store that owns this Folder object  <p>
 * api2test: public Store getStore()  <p>
 *
 * how2test: Call this API. If it returns object of type 'Store' <p>
 *	     then the testcase passes, otherwise it fails. <p>
 *	     This method can be invoked on a closed folder.
 */

public class getStore_Test extends MailTest {

    public static void main( String argv[] )
    {
        getStore_Test test = new getStore_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Folder: getStore()\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if( folder == null ) {
	         return Status.failed("Invalid folder object!");
       	     }
	     folder.open(Folder.READ_ONLY);
	  // BEGIN UNIT TEST 1:

	     out.println("UNIT TEST 1: getStore()");

	     Store istore = folder.getStore();	// API TEST
	     
	     folder.close(false);

	     Store jstore = folder.getStore();  // API TEST

	     if ( istore != null && jstore != null ) {
		  Folder defolder = istore.getDefaultFolder();
                  out.println("UNIT TEST 1: passed\n");
             } else {
                     out.println("UNIT TEST 1: FAILED\n");
                     errors++;
	     }
	  // END UNIT TEST 1:
	     store.close();
             checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
