/*
 * Copyright (c) 2002-2012 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Folder;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getName()</strong> API.
 * It does this by invoking the api under test and then checking
 * the type of the returned object.	<p>
 *
 *		Returns the name of this Folder
 * api2test: public String getName()  <p>
 *
 * how2test: Call this API. Verify that it returns a string. <p>
 *	     This method can be invoked on a open/closed Folder.
 */

public class getName_Test extends MailTest {

    public static void main( String argv[] )
    {
        getName_Test test = new getName_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Folder: getName()\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if (folder == null ) {
	         return Status.failed("Invalid folder object!");
       	     }
	     folder.open(Folder.READ_ONLY);
	     
	  // BEGIN UNIT TEST 1:
	     out.println("UNIT TEST 1: getName()");

	     String folderName1 = folder.getName();	// API TEST
	     folder.close(false);
	     String folderName2 = folder.getName();	// API TEST
	     
	     if(folderName1 != null && folderName2 != null ) {
		if( folderName1.equals(folderName2) ) {
		    out.println("Folder name is: "+ folderName1);
		    out.println("UNIT TEST 1: passed\n");
		} else {
			out.println("UNIT TEST 1: FAILED\n");
			errors++;
		}
	     }
	  // END UNIT TEST 1:
	     store.close();
             checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
