/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.FetchProfile;

import java.util.*;
import java.io.*;
import javax.mail.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>FetchProfile()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *	    Create an empty FetchProfile. <p>
 * api2test: public FetchProfile()  <p>
 *
 * how2test: Call this constructor, verify the type of object created to be that of
 *	     FetchProfile. If so then this testcase passes, otherwise it fails.
 */

public class fetchProfile_Test extends MailTest {

    public static void main( String argv[] )
    {
        fetchProfile_Test test = new fetchProfile_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class FetchProfile: FetchProfile(void)\n");

        try {
	   // BEGIN UNIT TEST 1:
	      out.println("UNIT TEST 1:  FetchProfile()");
	     
	      FetchProfile fp = new FetchProfile();	    // API TEST
	     
	      if( fp != null )
		  out.println("UNIT TEST 1: passed\n");
	      else {
		    out.println("UNIT TEST 1: FAILED\n");
		    errors++;
	      }
	   // END UNIT TEST 1:

              checkStatus();

        } catch ( Exception e ) {
              handlException(e);
        }
	return status;
     }
}
