/*
 * Copyright (c) 2008, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: StatusSingletonBean.java 62595 2011-04-20 20:38:55Z kgrucci $
 */
package com.sun.ts.tests.ejb30.common.statussingleton;

import java.util.HashMap;
import java.util.Map;

import javax.ejb.Singleton;

@Singleton
public class StatusSingletonBean {
    private Map<String, String> results = new HashMap<String, String>();

    public void addResult(int key, int sum) {
        results.put(String.valueOf(key), String.valueOf(sum));
    }

    public void addResult(String key, String val) {
        results.put(key, val);
    }

    public void removeResult(Integer key) {
        results.remove(String.valueOf(key));
    }

    public void removeResult(String key) {
        results.remove(key);
    }

    // IMPORTANT:
    // The client should wait and poll for the result stored in this class.
    // This method should not hold the lock and wait.
    public Integer getAndResetResult(Integer key) {
        final String sKey = String.valueOf(key);
        final String result = results.get(sKey);
        results.remove(sKey);
        return Integer.valueOf(result);
    }

    public String getAndResetResult(String key) {
        final String result = results.get(key);
        results.remove(key);
        return result;
    }

    public boolean isResultAvailable(Integer key) {
        return results.containsKey(String.valueOf(key));
    }

    public boolean isResultAvailable(String key) {
        return results.containsKey(key);
    }
}
