/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ThreeTestBean.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.migration.twothree;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import javax.ejb.EJB;
import javax.ejb.EJBContext;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.SessionContext;
import javax.annotation.Resource;


@Stateless(name="ThreeTestBean")
@Remote
public class ThreeTestBean implements ThreeTestIF {
    
    @Resource(name="sessionContext")
    private SessionContext sessionContext;
    
    @EJB(name="migrationBeanThreeRemote")
    private ThreeIF migrationBeanThreeRemote;
    
    @EJB(name="migrationBeanThreeLocal")
    private ThreeLocalIF migrationBeanThreeLocal;
    
    protected EJBContext getEJBContext() {
        return sessionContext;
    }
    
    public ThreeTestBean() {
    }
    
    public void remove() {
    }

    public void callRemote() throws TestFailedException {
        String expected = "from3Client";
        String reason = null;
        String result = migrationBeanThreeRemote.from3Client();
        if(expected.equals(result)) {
            //good
        } else {
            reason = "Expecting return value " + expected + ", actual " +
                    result;
            throw new TestFailedException(reason);
        }
    }

    public void callLocal() throws TestFailedException {
        String expected = "from3Client";
        String reason = null;
        String result = migrationBeanThreeLocal.from3Client();
        if(expected.equals(result)) {
            //good
        } else {
            reason = "Expecting return value " + expected + ", actual " +
                    result;
            throw new TestFailedException(reason);
        }
    }
   
}
