/*
/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ClientBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.migration.threetwo;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.EETest.Fault;
import java.util.Properties;

abstract public class ClientBase extends EETest {
    protected Properties props;
    private ThreeTestIF threeTestBean;
    
    abstract protected ThreeTestIF getTestBean();
    
    public void setup(String[] args, Properties p) throws Fault {
        props=p;
        threeTestBean = getTestBean();
    }
    
    public void  cleanup() throws Fault	{
    }
    
    protected void removeBeans() {
        if(threeTestBean != null) {
            try {
                threeTestBean.remove();
                TLogger.log("Successfully removed threeTestBean.");
            } catch (Exception e) {
                TLogger.log("Exception while removing threeTestBean " + e);
            }
        }
    }
    
    //////////////////////////////////////////////////////////////////////
    
    /*
     * testName: callRemoteTest
     * @test_Strategy:
     *
     */
    public void callRemoteTest() throws Fault {
        try {
            threeTestBean.callRemote();
        } catch (TestFailedException e) {
            throw new Fault(e);
        }
    }
    
    /*
     * testName: callLocalTest
     * @test_Strategy:
     *
     */
    public void callLocalTest() throws Fault {
        try {
            threeTestBean.callLocal();
        }catch (TestFailedException e) {
            throw new Fault(e);
        }
    }
    
    /*
     * testName: callRemoteSameTxContextTest
     * @test_Strategy:
     *
     */
    public void callRemoteSameTxContextTest() throws Fault {
        try {
            threeTestBean.callRemoteSameTxContext();
        }catch (TestFailedException e) {
            throw new Fault(e);
        }
    }
    
    /*
     * testName: callLocalSameTxContextTest
     * @test_Strategy:
     *
     */
    public void callLocalSameTxContextTest() throws Fault {
        try {
            threeTestBean.callLocalSameTxContext();
        }catch (TestFailedException e) {
            throw new Fault(e);
        }
    }
}
