/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: InterceptorForAll.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.invocationcontext;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import java.util.logging.Level;
import javax.interceptor.InvocationContext;
import javax.interceptor.AroundInvoke;

public class InterceptorForAll {
    
    public InterceptorForAll() {
        super();
    }
    
    @AroundInvoke
    public Object intercept(InvocationContext inv) throws Exception {
	Helper.getLogger().logp(Level.FINE, "InterceptorForAll", "intercept",
		"Invoking around-invoke method, target:" + inv.getTarget());
        InvocationContextTestImpl.interceptAll(inv);
        return inv.proceed();
    }
}
