/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BaseRemoteCalculator.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.calc;

/**
 * An implementation of RemoteCalculator interface.  It forwards
 * to an instance of <code>NoInterfaceRemoteCalculator</code> for all operations.
 * @author  Cheng Fang
 */
public class BaseRemoteCalculator implements RemoteCalculator {
   
    private NoInterfaceRemoteCalculator calc = new NoInterfaceRemoteCalculator();
    
    public BaseRemoteCalculator() {
    }

    /* (non-Javadoc)
     * @see com.sun.ts.tests.ejb30.common.calc.RemoteCalculator#removeAdd(int, int)
     */
    public int remoteAdd(int a, int b) {
        return calc.remoteAdd(a, b);
    }

    /* (non-Javadoc)
     * @see com.sun.ts.tests.ejb30.common.calc.RemoteCalculator#removeSubtract(int, int)
     */
    public int remoteSubtract(int a, int b) {
        return calc.remoteSubtract(a, b);
    }

    /* (non-Javadoc)
     * @see com.sun.ts.tests.ejb30.common.calc.RemoteCalculator#remoteThrowIt()
     */
    public void remoteThrowIt() throws CalculatorException {
        calc.remoteThrowIt();
    }
    
}
