/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: BaseLocalRemoteCalculator.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.calc;

/**
 * A base class for both local and remote calculators. It is intended to be
 * extended by session beans that provide both local and remote views.  But 
 * from the client view, it can only perform either local operations or remote
 * operations.
 * 
 * @author Cheng Fang
 */
public class BaseLocalRemoteCalculator extends BaseLocalCalculator implements
        RemoteCalculator {

    private BaseRemoteCalculator remoteCalc = new BaseRemoteCalculator();

    /*
     * (non-Javadoc)
     * 
     * @see com.sun.ts.tests.ejb30.common.calc.RemoteCalculator#remoteAdd(int,
     *      int)
     */
    public int remoteAdd(int a, int b) {
        return remoteCalc.remoteAdd(a, b);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.sun.ts.tests.ejb30.common.calc.RemoteCalculator#remoteSubtract(int,
     *      int)
     */
    public int remoteSubtract(int a, int b) {
        return remoteCalc.remoteSubtract(a, b);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.sun.ts.tests.ejb30.common.calc.RemoteCalculator#remoteThrowIt()
     */
    public void remoteThrowIt() throws CalculatorException {
        remoteCalc.remoteThrowIt();
    }

}
