/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: EJBVehicle.java 62592 2011-04-20 20:07:16Z kgrucci $
 */

package com.sun.ts.tests.common.vehicle.ejb;

import com.sun.ts.lib.harness.*;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.*;
import java.io.*;
import java.net.*;
import java.rmi.Remote;
import javax.ejb.*;
import java.util.*;
import com.sun.javatest.Status;

public class EJBVehicle implements SessionBean
{
	private EETest testObj;
	private Properties properties;
	private String[] arguments; 
	
	public void ejbCreate(String[] args, Properties p) throws CreateException
	{
            //Initialize TestUtil Reporting
            try 
            {	
                    TestUtil.init(p);
            }
            catch (Exception e) 
            {
                TestUtil.logErr("initLogging failed in ejb vehicle.", e);
                throw new EJBException();
            }

            arguments = args;
            properties = p;

            //create an instance of the test client
            try
            {
                Class c =
                Class.forName(p.getProperty("test_classname"));
                testObj = (EETest) c.newInstance();
            }
            catch(Exception e)
            {
                TestUtil.logErr("Failed to create the EETest instance in the vehicle", e);
                throw new EJBException();
            }
	    TestUtil.logTrace( "ejbcreate");
	}
	
	//the run method that we call here will either throw
	//an exception (failed), or return void (pass)
	public RemoteStatus runTest() 
    {
		RemoteStatus sTestStatus = new RemoteStatus(Status.passed(""));

	    TestUtil.logTrace("in runTest()" );

		try
		{
			//call EETest impl's run method
			sTestStatus = new RemoteStatus(testObj.run(arguments, properties));
			
			if(sTestStatus.getType() == Status.PASSED)
				TestUtil.logMsg("Test running in ejb vehicle passed");
			else
				TestUtil.logMsg("Test running in ejb vehicle failed");
		}
		catch(Throwable e)
		{	
			e.printStackTrace();
			TestUtil.logErr("Test running in ejb vehicle failed", e);
			sTestStatus = new RemoteStatus(Status.failed("Test running in ejb vehicle failed")); 
		}
		return sTestStatus;
	}
	
	public void setSessionContext(SessionContext sc) 
	{
	}
	
	public void ejbRemove() 
	{
	}
	
	public void ejbActivate() 
	{
	}
	
	public void ejbPassivate() 
	{
	}
}
