/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/common/taglibsig/validation/Validator.java $ $LastChangedDate: 2011-04-20 13:07:16 -0700 (Wed, 20 Apr 2011) $
 */
 
package com.sun.ts.tests.common.taglibsig.validation;

import com.sun.ts.tests.common.taglibsig.TagLibraryDescriptor;

import java.util.List;

/**
 * Performs validation of either all or part of a {@link TagLibraryDescriptor}.
 */
public interface Validator {

    /**
     * <p>Performs validations (specific to the particular implementation) of
     * two {@link TagLibraryDescriptor} instances.</p>
     * @param control - the <code>control</code> TagLibraryDescriptor
     * @param underTest - the TagLibraryDescriptor that we are validating for
     *                    correctness
     * @return
     */
    public List validate(TagLibraryDescriptor control, TagLibraryDescriptor underTest);

}
