/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: LogEntry.java 62564 2011-04-18 20:29:25Z kgrucci $
 */
package com.sun.ts.lib.tests.jbi;

import java.io.Serializable;

/*
 * This class represents a log entry written to a log buffer.  This
 * class is used to hold a single log message that may be cached inside
 * a JBI component and eventually retrieved by a test client for
 * verification.  As an example we may deploy a JBI component and
 * create log messages while the life cycle methods are running but
 * the test clients will have no way to receive these log messages in
 * real-time so they will need to be cached in the component until
 * the CTS test client can retrieve them.  This class implements
 * Serializable since it will be sent between VMs.
 *
 * TODO:  Do we really need this class or should we extend TestUtil?
 */
public class LogEntry implements Serializable {

    private static final long serialVersionUID = 1L;

    public LogEntry() {
    }

}
