/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

/*
 * $Id: BareBonesELContext.java 67177 2012-08-17 13:59:21Z dougd $
 */

package com.sun.ts.tests.el.common.elcontext;

import javax.el.ELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;

/* This ELContext contains only a single CompositeELResolver
   for use in testing the ELResolver API.
*/

public class BareBonesELContext extends ELContext {

    private final ELResolver elResolver;

    /*
     * Constructor.
     */
    public BareBonesELContext() {
	this.elResolver = new CompositeELResolver();
    }

    public ELResolver getELResolver() {                                                                        
        return (ELResolver) elResolver;
    }
                                                                                
    public ELContext getELContext() {
        return (ELContext) (this);
    }

    public VariableMapper getVariableMapper() {
	return null;
    }

    public FunctionMapper getFunctionMapper() {
	return null;
    }

}
