/*
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestRunException.java 69446 2013-01-10 11:55:21Z supol $
 */

package com.sun.ts.lib.harness;

/**
 * This class defines any exception thrown by the Regression extensions.
 *
 * @author Iris A Garcia
 * @version @(#)TestRunException.java	1.2 99/03/15
 */
public class TestRunException extends RuntimeException
{
	private static final long serialVersionUID = -9119523505446607510L;

	public TestRunException(String msg) {
	super(msg);
    } // TestRunException()

    public TestRunException(Throwable t) {
	super(t.getMessage(), t);
    } // TestRunException()

    public Throwable getThrowable() {
	return getCause();
    } // getThrowable()
}
