/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.concurrency.api.common.counter;

import javax.naming.*;
import java.util.concurrent.*;

public class CounterCallableTask implements Callable {

    private String countSingletionJndi = "";

    public CounterCallableTask(String countSingletionJndi) {
	this.countSingletionJndi = countSingletionJndi;
    }

    public Integer call() {
	try {
	    InitialContext context = new InitialContext();
	    CounterRemote counter = (CounterRemote) context
		    .lookup(countSingletionJndi);
	    counter.inc();
	    return counter.getCount();

	} catch (Exception e) {
	    throw new RuntimeException(e);
	}

    }
}
