/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedTopicSession;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.IllegalStateException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;

public class ClosedTopicSessionTests
extends ServiceEETest {
    private static final String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
    private static final String testName = "com.sun.ts.tests.jms.core.closedTopicSession.ClosedTopicSessionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedTopicSessionTests theTests = new ClosedTopicSessionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseSession(int type) throws Exception {
        if (type == 1 || type == 3) {
            this.tool = new JmsTool(type, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logMsg("Closing topic session");
            this.tool.getDefaultTopicSession().close();
        }
        this.logMsg("Session closed");
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            this.logMsg("Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.logTrace("In setup");
            this.jmsUser = p.getProperty("user");
            this.jmsPassword = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void closedTopicSessionCommitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(3);
            this.logMsg("Try to call commit with closed session.");
            try {
                this.tool.getDefaultTopicSession().commit();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCommitTest");
        }
    }

    public void closedTopicSessionCloseTest() throws Exception {
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to call close on closed session.");
            this.tool.getDefaultTopicSession().close();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCloseTest");
        }
    }

    public void closedTopicSessionCreateDurableSubscriberTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create DurableSubscriber with closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "TestDurableSubscriber");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateDurableSubscriberTest");
        }
    }

    public void closedTopicSessionCreateDurableSubscriberMsgSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create DurableSubscriber with message selector using closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "TestDurableSubscriberMsgSelector", "TEST = 'test'", false);
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateDurableSubscriberMsgSelectorTest");
        }
    }

    public void closedTopicSessionCreateTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create topic with closed session.");
            try {
                Topic topic = this.tool.getDefaultTopicSession().createTopic("closedTopicSessionCreateTopicTest");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateTopicTest");
        }
    }

    public void closedTopicSessionCreateSubscriberTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create Subscriber with closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic());
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateSubscriberTest");
        }
    }

    public void closedTopicSessionCreateSubscriberMsgSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create Subscriber with closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic(), "TEST = 'test'", false);
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateSubscriberMsgSelectorTest");
        }
    }

    public void closedTopicSessionCreatePublisherTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create Publisher with closed session.");
            try {
                TopicPublisher topicPublisher = this.tool.getDefaultTopicSession().createPublisher(this.tool.getDefaultTopic());
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreatePublisherTest");
        }
    }

    public void closedTopicSessionCreateTempTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create TemporaryTopic with closed session.");
            try {
                TemporaryTopic temporaryTopic = this.tool.getDefaultTopicSession().createTemporaryTopic();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateTempTopicTest");
        }
    }

    public void closedTopicSessionUnsubscribeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to call unsubscribe with closed session.");
            try {
                this.tool.getDefaultTopicSession().unsubscribe("TestDurableSubscription");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionUnsubscribeTest");
        }
    }

    public void closedTopicSessionCreateMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create message with closed session.");
            try {
                Message message = this.tool.getDefaultTopicSession().createMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateMessageTest");
        }
    }

    public void closedTopicSessionCreateBytesMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create BytesMessage with closed session.");
            try {
                BytesMessage bytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateBytesMessageTest");
        }
    }

    public void closedTopicSessionCreateMapMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create MapMessage with closed session.");
            try {
                MapMessage mapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateMapMessageTest");
        }
    }

    public void closedTopicSessionCreateObjectMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create ObjectMessage with closed session.");
            try {
                ObjectMessage objectMessage = this.tool.getDefaultTopicSession().createObjectMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateObjectMessageTest");
        }
    }

    public void closedTopicSessionCreateObject2MessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create ObjectMessage(object) with closed session.");
            try {
                String s = "Simple object";
                ObjectMessage m = this.tool.getDefaultTopicSession().createObjectMessage((Serializable)((Object)s));
                if (m != null) {
                    this.logMsg("ObjectMessage=" + m);
                }
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateObject2MessageTest");
        }
    }

    public void closedTopicSessionCreateStreamMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create StreamMessage with closed session.");
            try {
                StreamMessage streamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateStreamMessageTest");
        }
    }

    public void closedTopicSessionCreateTextMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultTopicSession().createTextMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateTextMessageTest");
        }
    }

    public void closedTopicSessionCreateText2MessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultTopicSession().createTextMessage("test message");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionCreateText2MessageTest");
        }
    }

    public void closedTopicSessionGetTransactedTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to call getTransacted() with closed session.");
            try {
                boolean bl = this.tool.getDefaultTopicSession().getTransacted();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionGetTransactedTest");
        }
    }

    public void closedTopicSessionRollbackTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to call rollback() with closed session.");
            try {
                this.tool.getDefaultTopicSession().rollback();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionRollbackTest");
        }
    }

    public void closedTopicSessionRecoverTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to call recover() with closed session.");
            try {
                this.tool.getDefaultTopicSession().recover();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicSessionRecoverTest");
        }
    }

    public void closedTopicSessionSubscriberCloseTest() throws Exception {
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call close again");
            this.tool.getDefaultTopicSubscriber().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSubscriberCloseTest", e);
        }
    }

    public void closedTopicSessionGetMessageSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultTopicSubscriber().getMessageSelector();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetMessageSelectorTest", e);
        }
    }

    public void closedTopicSessionReceiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call receive");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionReceiveTest", e);
        }
    }

    public void closedTopicSessionReceiveTimeoutTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive(this.timeout);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionReceiveTimeoutTest", e);
        }
    }

    public void closedTopicSessionReceiveNoWaitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receiveNoWait();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionReceiveNoWaitTest", e);
        }
    }

    public void closedTopicSessionGetNoLocalTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getNoLocal");
            try {
                boolean foo = this.tool.getDefaultTopicSubscriber().getNoLocal();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetNoLocalTest", e);
        }
    }

    public void closedTopicSessionSubscriberGetTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicSubscriber().getTopic();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSubscriberGetTopicTest", e);
        }
    }

    public void closedTopicSessionPublisherCloseTest() throws Exception {
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call close again");
            this.tool.getDefaultTopicPublisher().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionPublisherCloseTest", e);
        }
    }

    public void closedTopicSessionGetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getDeliveryMode();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetDeliveryModeTest", e);
        }
    }

    public void closedTopicSessionGetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageID();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetDisableMessageIDTest", e);
        }
    }

    public void closedTopicSessionGetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageTimestamp();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetDisableMessageTimestampTest", e);
        }
    }

    public void closedTopicSessionGetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getPriority");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getPriority();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetPriorityTest", e);
        }
    }

    public void closedTopicSessionGetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultTopicPublisher().getTimeToLive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetTimeToLiveTest", e);
        }
    }

    public void closedTopicSessionSetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call setDeliveryMode");
            try {
                this.tool.getDefaultTopicPublisher().setDeliveryMode(2);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSetDeliveryModeTest", e);
        }
    }

    public void closedTopicSessionSetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call setDisableMessageID");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageID(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSetDisableMessageIDTest", e);
        }
    }

    public void closedTopicSessionSetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageTimestamp(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSetDisableMessageTimestampTest", e);
        }
    }

    public void closedTopicSessionSetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call setPriority");
            try {
                this.tool.getDefaultTopicPublisher().setPriority(4);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSetPriorityTest", e);
        }
    }

    public void closedTopicSessionSetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call setTimeToLive");
            try {
                this.tool.getDefaultTopicPublisher().setTimeToLive(0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSetTimeToLiveTest", e);
        }
    }

    public void closedTopicSessionPublisherGetTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicPublisher().getTopic();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionPublisherGetTopicTest", e);
        }
    }

    public void closedTopicSessionPublish1Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call publish(Message)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionPublish1Test", e);
        }
    }

    public void closedTopicSessionPublish2Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call publish(Message,int,int,long)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionPublish2Test", e);
        }
    }
}

