/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.beanparam.plain;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.beanparam.bean.BeanParamEntity;
import ee.jakarta.tck.ws.rs.ee.rs.beanparam.bean.InnerBeanParamEntity;
import ee.jakarta.tck.ws.rs.ee.rs.beanparam.plain.AppConfig;
import ee.jakarta.tck.ws.rs.ee.rs.beanparam.plain.Resource;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 201L;
    private static final String CONTENT = "Anything";
    private static final String FIRST = "FIRST";
    private static final String SECOND = "SECOND";
    private static final String THIRD = "Third";
    private static final String FOURTH = "Fourth";
    private static final String FIFTH = "Fifth";
    private static final String SIXTH = "Sixth";
    private static final String SEVENTH = "Seventh";
    private static final String EIGHTH = "Eighth";
    private static final String NINETH = "Nineth";
    private static final String TENTH = "Tenth";
    private static final String ELEVENTH = "Eleventh";
    private static final String TWELVENTH = "Twelveth";

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_beanparam_plain_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/beanparam/plain/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_beanparam_plain_web.war");
        archive.addClasses(new Class[]{AppConfig.class, Resource.class, BeanParamEntity.class, InnerBeanParamEntity.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void queryParamInParamTest() throws JAXRSCommonClient.Fault {
        String[] reqArgs = JAXRSClientIT.getRequestArguments("Query");
        String request = this.buildRequestQuery(JAXRSCommonClient.Request.POST, "queryparam", reqArgs[0], reqArgs[1]);
        this.invoke(request);
    }

    @Test
    public void queryParamOnFieldTest() throws JAXRSCommonClient.Fault {
        String[] reqArgs = JAXRSClientIT.getRequestArguments("Query");
        String request = this.buildRequestQuery(JAXRSCommonClient.Request.POST, "queryfield", reqArgs[0], reqArgs[1]);
        this.invoke(request);
    }

    @Test
    public void formParamInParamTest() throws JAXRSCommonClient.Fault {
        String[] reqArgs = JAXRSClientIT.getRequestArguments("Form");
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "formparam");
        this.invoke(request, JAXRSClientIT.andize(CONTENT, reqArgs[0], reqArgs[1]));
    }

    @Test
    public void formParamOnFieldTest() throws JAXRSCommonClient.Fault {
        String[] reqArgs = JAXRSClientIT.getRequestArguments("Form");
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "formfield");
        this.invoke(request, JAXRSClientIT.andize(CONTENT, reqArgs[0], reqArgs[1]));
    }

    @Test
    public void headerParamInParamTest() throws JAXRSCommonClient.Fault {
        String[] reqArgs = JAXRSClientIT.getRequestArguments("Header");
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "headerparam");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, reqArgs[0].replace('=', ':'));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, reqArgs[1].replace('=', ':'));
        this.invoke(request);
    }

    @Test
    public void headerParamOnFieldTest() throws JAXRSCommonClient.Fault {
        String[] reqArgs = JAXRSClientIT.getRequestArguments("Header");
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "headerfield");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, reqArgs[0].replace('=', ':'));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, reqArgs[1].replace('=', ':'));
        this.invoke(request);
    }

    @Test
    public void pathParamInParamTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "pathparam/", FIRST, "/", SECOND);
        this.invoke(request);
    }

    @Test
    public void pathParamOnFieldTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "pathfield/", FIRST, "/", SECOND);
        this.invoke(request);
    }

    @Test
    public void matrixParamInParamTest() throws JAXRSCommonClient.Fault {
        String[] reqArgs = JAXRSClientIT.getRequestArguments("Matrix");
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "matrixparam;", reqArgs[0], ";", reqArgs[1]);
        this.invoke(request);
    }

    @Test
    public void matrixParamOnFieldTest() throws JAXRSCommonClient.Fault {
        String[] reqArgs = JAXRSClientIT.getRequestArguments("Matrix");
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "matrixfield;", reqArgs[0], ";", reqArgs[1]);
        this.invoke(request);
    }

    @Test
    public void cookieParamInParamTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "cookieparam");
        this.buildCookie();
        this.invoke(request);
    }

    @Test
    public void cookieParamOnFieldTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "cookiefield");
        this.buildCookie();
        this.invoke(request);
    }

    @Test
    public void allParamsInParamTest() throws JAXRSCommonClient.Fault {
        this.allParamsTest("allparam");
    }

    @Test
    public void allParamsOnFieldTest() throws JAXRSCommonClient.Fault {
        this.allParamsTest("allfield");
    }

    private void allParamsTest(String path) throws JAXRSCommonClient.Fault {
        String[] formArgs = JAXRSClientIT.getRequestArguments("Form", THIRD, FOURTH);
        String[] headerArgs = JAXRSClientIT.getRequestArguments("Header", FIFTH, SIXTH);
        String[] matrixArgs = JAXRSClientIT.getRequestArguments("Matrix", SEVENTH, EIGHTH);
        String[] queryArgs = JAXRSClientIT.getRequestArguments("Query", ELEVENTH, TWELVENTH);
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, path, "/", NINETH, "/", TENTH, ";", matrixArgs[0], ";", matrixArgs[1], "?", JAXRSClientIT.andize(queryArgs[0], queryArgs[1]));
        this.buildCookie();
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, headerArgs[0].replace('=', ':'));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, headerArgs[1].replace('=', ':'));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, THIRD);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, FOURTH);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, FIFTH);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, SIXTH);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, SEVENTH);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, EIGHTH);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, NINETH);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, TENTH);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ELEVENTH);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, TWELVENTH);
        this.invoke(request, JAXRSClientIT.andize(CONTENT, formArgs[0], formArgs[1]));
    }

    private static String[] getRequestArguments(String type) {
        return JAXRSClientIT.getRequestArguments(type, FIRST, SECOND);
    }

    private static String[] getRequestArguments(String type, String first, String second) {
        String[] args = new String[]{"bpe" + type + "=" + first, "inner" + type + "=" + second};
        return args;
    }

    private void invoke(String request, String content) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, FIRST);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, SECOND);
        this.invoke();
    }

    private void invoke(String request) throws JAXRSCommonClient.Fault {
        this.invoke(request, CONTENT);
    }

    private String buildRequestQuery(JAXRSCommonClient.Request type, String path, String ... query) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildRequest(type, path));
        sb.append("?").append(JAXRSClientIT.andize(query));
        return sb.toString();
    }

    private static String andize(String ... args) {
        StringBuilder sb = new StringBuilder();
        if (args != null) {
            for (int i = 0; i != args.length; ++i) {
                if (i != 0) {
                    sb.append("&");
                }
                sb.append(args[i]);
            }
        }
        return sb.toString();
    }

    private void buildCookie() {
        String[] reqArgs = JAXRSClientIT.getRequestArguments("Cookie");
        StringBuilder sb = new StringBuilder().append("Cookie:").append(reqArgs[0]).append(";Version=1;").append(reqArgs[1]).append(";Version=1");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, sb.toString());
    }
}

