/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.client.responseprocessingexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.ResponseProcessingException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 4199815250447993450L;
    static final Response.Status STATUS = Response.Status.EXPECTATION_FAILED;
    static final String MESSAGE = "Exception thrown by TCK";

    public JAXRSClientIT() {
        this.setContextRoot("/jaxrs_api_rs_processingexception_web");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorWithRuntimeExceptionTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse(STATUS);
        IllegalStateException ile = new IllegalStateException("TCK exception");
        ResponseProcessingException mpe = new ResponseProcessingException(response, (Throwable)ile);
        this.assertCause(mpe, ile);
        this.assertMessage(mpe, ile.getMessage());
        this.assertResponse(mpe);
    }

    @Test
    public void constructorWithCheckedExceptionTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse(STATUS);
        IOException ioe = new IOException("TCK exception");
        ResponseProcessingException mpe = new ResponseProcessingException(response, (Throwable)ioe);
        this.assertCause(mpe, ioe);
        this.assertMessage(mpe, ioe.getMessage());
        this.assertResponse(mpe);
    }

    @Test
    public void constructorWithNullThrowableTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse(STATUS);
        ResponseProcessingException mpe = new ResponseProcessingException(response, (Throwable)null);
        this.assertResponse(mpe);
        JAXRSClientIT.assertNull(mpe.getCause(), "getCause does not work for ResponseProcessingException and null cause");
        JAXRSClientIT.assertNull(mpe.getMessage(), "getMessage does not work for ResponseProcessingException and null cause");
    }

    @Test
    public void constructorWithNullThrowableNullMessageTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse(STATUS);
        ResponseProcessingException mpe = new ResponseProcessingException(response, (String)null, (Throwable)null);
        this.assertResponse(mpe);
        JAXRSClientIT.assertNull(mpe.getCause(), "getCause does not work for ResponseProcessingException and null cause");
        JAXRSClientIT.assertNull(mpe.getMessage(), "getMessage does not work for ResponseProcessingException and null cause");
    }

    @Test
    public void constructorWithNullThrowableNotNullMessageTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse(STATUS);
        ResponseProcessingException mpe = new ResponseProcessingException(response, MESSAGE, (Throwable)null);
        this.assertResponse(mpe);
        JAXRSClientIT.assertNull(mpe.getCause(), "getCause does not work for ResponseProcessingException and null cause and not null message");
        this.assertMessage(mpe, MESSAGE);
    }

    @Test
    public void constructorWithRuntimeExceptionNullMessageTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse(STATUS);
        IllegalStateException ise = new IllegalStateException("JAXRS TCK exception");
        ResponseProcessingException mpe = new ResponseProcessingException(response, (String)null, (Throwable)ise);
        this.assertResponse(mpe);
        this.assertCause(mpe, ise);
        JAXRSClientIT.assertNull(mpe.getMessage(), "getMessage does not work for", "ResponseProcessingException and RuntimeException and null message");
    }

    @Test
    public void constructorWithCheckedExceptionNullMessageTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse(STATUS);
        IOException ioe = new IOException("JAXRS TCK exception");
        ResponseProcessingException mpe = new ResponseProcessingException(response, (String)null, (Throwable)ioe);
        this.assertResponse(mpe);
        this.assertCause(mpe, ioe);
        JAXRSClientIT.assertNull(mpe.getMessage(), "getMessage does not work for", "ResponseProcessingException and CheckedException and null message");
    }

    @Test
    public void constructorWithRuntimeExceptionAndNotNullMessageTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse(STATUS);
        IllegalStateException ise = new IllegalStateException("JAXRS TCK exception");
        ResponseProcessingException mpe = new ResponseProcessingException(response, MESSAGE, (Throwable)ise);
        this.assertResponse(mpe);
        this.assertCause(mpe, ise);
        this.assertMessage(mpe, MESSAGE);
    }

    @Test
    public void constructorWithCheckedExceptionAndNotNullMessageTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse(STATUS);
        IOException ioe = new IOException("JAXRS TCK exception");
        ResponseProcessingException mpe = new ResponseProcessingException(response, MESSAGE, (Throwable)ioe);
        this.assertResponse(mpe);
        this.assertCause(mpe, ioe);
        this.assertMessage(mpe, MESSAGE);
    }

    @Test
    public void constructorWithNotNullMessageTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse(STATUS);
        ResponseProcessingException mpe = new ResponseProcessingException(response, MESSAGE);
        JAXRSClientIT.assertNull(mpe.getCause(), "getCause does not work for ResponseProcessingException and not null message");
        this.assertResponse(mpe);
        this.assertMessage(mpe, MESSAGE);
    }

    @Test
    public void constructorWithNullMessageTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse(STATUS);
        ResponseProcessingException mpe = new ResponseProcessingException(response, (String)null);
        this.assertResponse(mpe);
        JAXRSClientIT.assertNull(mpe.getCause(), "getCause does not work for ResponseProcessingException and null message");
        JAXRSClientIT.assertNull(mpe.getMessage(), "getMessage does not work for ResponseProcessingException and null message");
    }

    protected Response buildResponse(Response.Status status) {
        return Response.status((Response.Status)status).build();
    }

    protected void assertResponse(ResponseProcessingException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getResponse(), "#getResponse is null");
        Response response = e.getResponse();
        JAXRSClientIT.assertEqualsInt(response.getStatus(), STATUS.getStatusCode(), "response contains unexpected status", response.getStatus());
        JAXRSClientIT.logMsg("response contains expected", STATUS, "status");
    }

    protected void assertCause(ResponseProcessingException e, Throwable expected) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(e.getCause(), expected, "#getCause does not contain expected", expected, "but", e.getCause());
        JAXRSClientIT.logMsg("getCause contains expected", expected);
    }

    protected void assertMessage(ResponseProcessingException e, String message) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getMessage(), "#getMessage is null");
        JAXRSClientIT.assertContains(e.getMessage(), message, new Object[]{"ResponseProcessingException#getMessage()", "does not contain expected message", message, "but", e.getMessage()});
        JAXRSClientIT.logMsg("ResponseProcessingException#getMesaage contains expected message", message);
    }
}

