/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.cdo.migration;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.internal.migration.internal.ForwardConverter;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.ReferenceSlot;

public class StrategyForwardConverter
extends ForwardConverter {
    Collection<EPackage> rootPackages;

    public StrategyForwardConverter(Collection<EPackage> ePackages) {
        this.rootPackages = ePackages;
    }

    protected Instance newInstance(EObject eObject, boolean proxy) {
        EObject find = this.find((EObject)eObject.eClass());
        if (find instanceof EClass) {
            Instance element = this.model.newInstance((EClass)find);
            this.mapping.put(eObject, element);
            if (proxy) {
                element.setUri(EcoreUtil.getURI((EObject)eObject));
            }
            return element;
        }
        return null;
    }

    protected void initInstance(EObject eObject) {
        Object value;
        Instance element = this.resolve(eObject);
        EClass c = eObject.eClass();
        for (EAttribute attribute : c.getEAllAttributes()) {
            EObject lookupAttribute;
            if (this.ignore((EStructuralFeature)attribute) || !((lookupAttribute = this.find((EObject)attribute)) instanceof EAttribute) || !eObject.eIsSet((EStructuralFeature)attribute)) continue;
            value = eObject.eGet((EStructuralFeature)attribute);
            element.set((EStructuralFeature)lookupAttribute, value);
        }
        for (EReference reference : c.getEAllReferences()) {
            EObject lookupReference;
            if (this.ignore((EStructuralFeature)reference) || !((lookupReference = this.find((EObject)reference)) instanceof EReference)) continue;
            value = eObject.eGet((EStructuralFeature)reference);
            if (reference.isMany()) {
                List valueEObjects = (List)value;
                int index = 0;
                for (EObject valueEObject : valueEObjects) {
                    Instance valueInstance = this.resolve(valueEObject);
                    if (reference.isUnique() && ((List)element.get((EStructuralFeature)lookupReference)).contains(valueInstance)) {
                        ReferenceSlot referenceSlot = (ReferenceSlot)element.getSlot((EStructuralFeature)lookupReference);
                        try {
                            referenceSlot.getValues().move(index, (Object)valueInstance);
                            ++index;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                        continue;
                    }
                    element.add((EStructuralFeature)lookupReference, index, (Object)valueInstance);
                    ++index;
                }
                continue;
            }
            if (value == null) continue;
            EObject valueEObject = (EObject)value;
            Instance valueInstance = this.resolve(valueEObject);
            element.set((EStructuralFeature)lookupReference, (Object)valueInstance);
        }
    }

    private EObject find(EObject sourceElement) {
        if (sourceElement == EcorePackage.eINSTANCE) {
            return sourceElement;
        }
        EObject sourceParent = sourceElement.eContainer();
        if (sourceParent == null) {
            EPackage sourcePackage = (EPackage)sourceElement;
            for (EPackage targetPackage : this.rootPackages) {
                if (!targetPackage.getNsURI().equals(sourcePackage.getNsURI())) continue;
                return targetPackage;
            }
            return sourcePackage;
        }
        EObject targetParent = this.find(sourceParent);
        if (targetParent == sourceParent) {
            return sourceElement;
        }
        EReference reference = sourceElement.eContainmentFeature();
        if (reference.isMany()) {
            List targetChildren = (List)targetParent.eGet((EStructuralFeature)reference);
            for (EObject t : targetChildren) {
                if (!(t instanceof ENamedElement) || !(sourceElement instanceof ENamedElement) || !((ENamedElement)t).getName().equals(((ENamedElement)sourceElement).getName())) continue;
                return t;
            }
            List sourceChildren = (List)sourceParent.eGet((EStructuralFeature)reference);
            int index = sourceChildren.indexOf(sourceElement);
            EObject targetElement = (EObject)targetChildren.get(index);
            return targetElement;
        }
        EObject targetElement = (EObject)targetParent.eGet((EStructuralFeature)reference);
        return targetElement;
    }
}

