/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetsTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SetTargetsDialog
extends Dialog {
    private static String DIALOG_SETTINGS_SECTION = "SetTargetsDialogSettings";
    private ILaunchConfigurationWorkingCopy fConfiguration;
    private AntTargetsTab fTargetsTab;

    public SetTargetsDialog(Shell parentShell, ILaunchConfigurationWorkingCopy config) {
        super(parentShell);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.fConfiguration = config;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(AntLaunchConfigurationMessages.SetTargetsDialog_0);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fTargetsTab = new AntTargetsTab();
        this.fTargetsTab.createControl(composite);
        this.fTargetsTab.initializeFrom((ILaunchConfiguration)this.fConfiguration);
        SetTargetsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        this.fTargetsTab.performApply(this.fConfiguration);
        super.okPressed();
    }

    protected String getTargetsSelected() {
        String defaultValue = null;
        if (!this.fTargetsTab.isTargetSelected()) {
            defaultValue = "";
        }
        try {
            return this.fConfiguration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", defaultValue);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(SetTargetsDialog.class)).getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }
}

