/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;
import org.eclipse.pde.internal.build.site.BuildTimeFeatureFactory;
import org.eclipse.pde.internal.build.site.BuildTimeSiteContentProvider;
import org.eclipse.pde.internal.build.site.FilteringState;
import org.eclipse.pde.internal.build.site.PDEState;
import org.eclipse.pde.internal.build.site.ReachablePlugin;
import org.eclipse.pde.internal.build.site.compatibility.FeatureReference;
import org.osgi.framework.Filter;
import org.osgi.framework.Version;

public class BuildTimeSite
implements IPDEBuildConstants,
IXMLConstants {
    private final BuildTimeFeatureFactory factory = new BuildTimeFeatureFactory();
    private final Map<String, Set<BuildTimeFeature>> featureCache = new HashMap<String, Set<BuildTimeFeature>>();
    private final Map<URL, BuildTimeFeature> featureURLCache = new HashMap<URL, BuildTimeFeature>();
    private List<FeatureReference> featureReferences;
    private BuildTimeSiteContentProvider contentProvider;
    private boolean featuresResolved = false;
    private PDEState state;
    private Properties repositoryVersions;
    private boolean reportResolutionErrors;
    private Properties platformProperties;
    private String[] eeSources;
    private List<String> rootFeaturesForFilter;
    private List<String> rootPluginsForFiler;
    private boolean filter = false;
    private final Comparator<Feature> featureComparator = (arg0, arg1) -> {
        Version v0 = new Version(arg0.getVersion());
        Version v1 = new Version(arg1.getVersion());
        return -1 * v0.compareTo(v1);
    };

    public void setReportResolutionErrors(boolean value) {
        this.reportResolutionErrors = value;
    }

    public void setPlatformPropeties(Properties platformProperties) {
        this.platformProperties = platformProperties;
    }

    public Properties getFeatureVersions() {
        if (this.repositoryVersions == null) {
            this.repositoryVersions = new Properties();
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(String.valueOf(AbstractScriptGenerator.getWorkingDirectory()) + '/' + "featureVersions.properties"));){
                    this.repositoryVersions.load(input);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return this.repositoryVersions;
    }

    private Properties getUIPlatformProperties() {
        Properties result = new Properties();
        result.put("osgi.resolveOptional", "true");
        result.put("osgi.resolverMode", "development");
        return result;
    }

    private Collection<File> removeDuplicates(Collection<File> bundles) {
        LinkedHashSet<File> result = new LinkedHashSet<File>(bundles.size() / 2);
        for (File bundle : bundles) {
            try {
                bundle = bundle.getCanonicalFile();
            }
            catch (IOException iOException) {}
            if (result.contains(bundle)) continue;
            result.add(bundle);
        }
        return result;
    }

    public PDEState getRegistry() throws CoreException {
        if (this.state == null) {
            BuildTimeSiteContentProvider provider = this.getSiteContentProvider();
            if (provider.getInitialState() != null) {
                this.state = new PDEState(provider.getInitialState());
                this.state.setEESources(this.eeSources);
                this.state.setPlatformProperties(this.getUIPlatformProperties());
                this.state.resolveState();
                return this.state;
            }
            if (this.filter) {
                this.state = new FilteringState();
                ((FilteringState)this.state).setFilter(this.findAllReferencedPlugins());
            } else {
                this.state = new PDEState();
            }
            if (this.platformProperties != null) {
                this.state.setPlatformProperties(this.platformProperties);
            }
            Collection<File> bundles = this.removeDuplicates(provider.getPluginPaths());
            this.state.addBundles(bundles);
            this.state.setEESources(this.eeSources);
            if (this.state instanceof FilteringState) {
                ((FilteringState)this.state).setFilter(null);
            }
            this.state.resolveState();
            BundleDescription[] allBundles = this.state.getState().getBundles();
            BundleDescription[] resolvedBundles = this.state.getState().getResolvedBundles();
            if (allBundles.length == resolvedBundles.length) {
                return this.state;
            }
            if (this.reportResolutionErrors) {
                MultiStatus errors = new MultiStatus("org.eclipse.pde.build", 1, Messages.exception_registryResolution, null);
                BundleDescription[] all = this.state.getState().getBundles();
                StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
                BundleDescription[] bundleDescriptionArray = all;
                int n = all.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleDescription element = bundleDescriptionArray[n2];
                    if (!element.isResolved()) {
                        ResolverError[] resolutionErrors = this.state.getState().getResolverErrors(element);
                        VersionConstraint[] versionErrors = helper.getUnsatisfiedConstraints(element);
                        if (!BuildTimeSite.isConfigError(element, resolutionErrors, AbstractScriptGenerator.getConfigInfos())) {
                            String errorMessage = "Bundle " + element.getSymbolicName() + ":\n" + BuildTimeSite.getResolutionErrorMessage(resolutionErrors);
                            VersionConstraint[] versionConstraintArray = versionErrors;
                            int n3 = versionErrors.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                VersionConstraint versionError = versionConstraintArray[n4];
                                errorMessage = String.valueOf(errorMessage) + '\t' + BuildTimeSite.getResolutionFailureMessage(versionError) + '\n';
                                ++n4;
                            }
                            errors.add((IStatus)new Status(2, "org.eclipse.pde.build", 2, errorMessage, null));
                        }
                    }
                    ++n2;
                }
                if (errors.getChildren().length > 0) {
                    BundleHelper.getDefault().getLog().log((IStatus)errors);
                }
            }
        }
        if (!this.state.getState().isResolved()) {
            this.state.state.resolve(true);
        }
        return this.state;
    }

    public IStatus missingPlugin(String id, String version, Feature containingFeature, boolean throwException) throws CoreException {
        BundleDescription bundle = this.state.getBundle(id, version, false);
        if (bundle == null) {
            String message = NLS.bind((String)Messages.exception_missingPlugin, (Object)(String.valueOf(id) + "_" + version));
            if (containingFeature != null) {
                message = NLS.bind((String)Messages.includedFromFeature, (Object)containingFeature.getId(), (Object)message);
            }
            Status status = new Status(4, "org.eclipse.pde.build", 5, message, null);
            if (throwException) {
                throw new CoreException((IStatus)status);
            }
            return status;
        }
        if (bundle.isResolved()) {
            return null;
        }
        ResolverError[] resolutionErrors = this.state.getState().getResolverErrors(bundle);
        return BuildTimeSite.missingPlugin(bundle, resolutionErrors, containingFeature, throwException);
    }

    public static IStatus missingPlugin(BundleDescription bundle, ResolverError[] resolutionErrors, Feature containingFeature, boolean throwException) throws CoreException {
        StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
        VersionConstraint[] versionErrors = helper.getUnsatisfiedConstraints(bundle);
        String message = NLS.bind((String)Messages.exception_unresolvedPlugin, (Object)(String.valueOf(bundle.getSymbolicName()) + '_' + bundle.getVersion().toString()));
        if (containingFeature != null) {
            message = NLS.bind((String)Messages.includedFromFeature, (Object)containingFeature.getId(), (Object)message);
        }
        message = String.valueOf(message) + ":\n" + BuildTimeSite.getResolutionErrorMessage(resolutionErrors);
        VersionConstraint[] versionConstraintArray = versionErrors;
        int n = versionErrors.length;
        int n2 = 0;
        while (n2 < n) {
            VersionConstraint versionError = versionConstraintArray[n2];
            message = String.valueOf(message) + '\t' + BuildTimeSite.getResolutionFailureMessage(versionError) + '\n';
            ++n2;
        }
        Status status = new Status(4, "org.eclipse.pde.build", 5, message, null);
        if (throwException) {
            throw new CoreException((IStatus)status);
        }
        return status;
    }

    public static boolean isConfigError(BundleDescription bundle, ResolverError[] errors, List<Config> configs) {
        Hashtable<String, String> environment = new Hashtable<String, String>(3);
        Filter bundleFilter = BundleHelper.getDefault().getFilter(bundle);
        if (bundleFilter != null && BuildTimeSite.hasPlatformFilterError(errors) != null) {
            for (Config aConfig : configs) {
                ((Dictionary)environment).put("osgi.os", aConfig.getOs());
                ((Dictionary)environment).put("osgi.ws", aConfig.getWs());
                ((Dictionary)environment).put("osgi.arch", aConfig.getArch());
                if (!bundleFilter.match(environment)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static ResolverError hasPlatformFilterError(ResolverError[] errors) {
        ResolverError[] resolverErrorArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverError error = resolverErrorArray[n2];
            if ((error.getType() & 0x2000) != 0) {
                return error;
            }
            if ((error.getType() & 0x10000) != 0) {
                return error;
            }
            ++n2;
        }
        return null;
    }

    public static String getResolutionErrorMessage(ResolverError[] errors) {
        String errorMessage = "";
        ResolverError[] resolverErrorArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverError error = resolverErrorArray[n2];
            if ((error.getType() & 0x4078) != 0) {
                errorMessage = String.valueOf(errorMessage) + '\t' + error.toString() + '\n';
            }
            ++n2;
        }
        return errorMessage;
    }

    public static String getResolutionFailureMessage(VersionConstraint unsatisfied) {
        if (unsatisfied.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (unsatisfied instanceof ImportPackageSpecification) {
            return NLS.bind((String)Messages.unsatisfied_import, (Object)BuildTimeSite.displayVersionConstraint(unsatisfied));
        }
        if (unsatisfied instanceof NativeCodeSpecification) {
            return NLS.bind((String)Messages.unsatisfied_nativeSpec, (Object)unsatisfied.toString());
        }
        if (unsatisfied instanceof BundleSpecification) {
            if (((BundleSpecification)unsatisfied).isOptional()) {
                return NLS.bind((String)Messages.unsatisfied_optionalBundle, (Object)BuildTimeSite.displayVersionConstraint(unsatisfied));
            }
            return NLS.bind((String)Messages.unsatisfied_required, (Object)BuildTimeSite.displayVersionConstraint(unsatisfied));
        }
        return NLS.bind((String)Messages.unsatisfied_host, (Object)BuildTimeSite.displayVersionConstraint(unsatisfied));
    }

    private static String displayVersionConstraint(VersionConstraint constraint) {
        VersionRange versionSpec = constraint.getVersionRange();
        if (versionSpec == null) {
            return constraint.getName();
        }
        return String.valueOf(constraint.getName()) + '_' + versionSpec;
    }

    public BuildTimeFeature findFeature(String featureId, String versionId, boolean throwsException) throws CoreException {
        VersionRange range = Utils.createVersionRange(versionId);
        return this.findFeature(featureId, range, throwsException);
    }

    private BuildTimeFeature findFeature(String featureId, VersionRange range, boolean throwsException) throws CoreException {
        if (range == null) {
            range = VersionRange.emptyRange;
        }
        if (!this.featuresResolved) {
            this.resolveFeatureReferences();
        }
        if (this.featureCache.containsKey(featureId)) {
            Set<BuildTimeFeature> featureSet = this.featureCache.get(featureId);
            for (BuildTimeFeature feature : featureSet) {
                Version featureVersion = new Version(feature.getVersion());
                if (!range.isIncluded(featureVersion)) continue;
                return feature;
            }
        }
        if (throwsException) {
            String message = null;
            message = range.equals((Object)VersionRange.emptyRange) ? NLS.bind((String)Messages.exception_missingFeature, (Object)featureId) : NLS.bind((String)Messages.exception_missingFeatureInRange, (Object)featureId, (Object)range);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
        }
        return null;
    }

    private void resolveFeatureReferences() {
        FeatureReference[] features;
        FeatureReference[] featureReferenceArray = features = this.getFeatureReferences();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureReference feature2 = featureReferenceArray[n2];
            try {
                feature2.getFeature();
            }
            catch (CoreException e) {
                String message = NLS.bind((String)Messages.exception_featureParse, (Object)feature2.getURL());
                Status status = new Status(4, "org.eclipse.pde.build", 1, message, (Throwable)e);
                BundleHelper.getDefault().getLog().log((IStatus)status);
            }
            ++n2;
        }
        this.featuresResolved = true;
    }

    public void addFeatureReferenceModel(File featureXML) {
        if (featureXML.exists()) {
            try {
                URL featureURL = new URL("file:" + featureXML.getAbsolutePath() + '/');
                FeatureReference featureRef = new FeatureReference();
                featureRef.setSiteModel(this);
                featureRef.setURLString(featureURL.toExternalForm());
                this.addFeatureReferenceModel(featureRef);
            }
            catch (MalformedURLException e) {
                BundleHelper.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.pde.build", 20, NLS.bind((String)Messages.warning_cannotLocateSource, (Object)featureXML.getAbsolutePath()), (Throwable)e));
            }
        }
    }

    public void addFeatureReferenceModel(FeatureReference featureReference) {
        if (this.featureReferences == null) {
            this.featureReferences = new ArrayList<FeatureReference>();
        }
        this.featureReferences.add(featureReference);
        this.featuresResolved = false;
    }

    private SortedSet<ReachablePlugin> findAllReferencedPlugins() throws CoreException {
        ArrayList<BuildTimeFeature> rootFeatures = new ArrayList<BuildTimeFeature>();
        TreeSet<ReachablePlugin> allPlugins = new TreeSet<ReachablePlugin>();
        for (String string : this.rootFeaturesForFilter) {
            BuildTimeFeature correspondingFeature = this.findFeature(string, (String)null, true);
            if (correspondingFeature == null) {
                return null;
            }
            rootFeatures.add(correspondingFeature);
        }
        for (String string : this.rootPluginsForFiler) {
            allPlugins.add(new ReachablePlugin(string, ReachablePlugin.WIDEST_RANGE));
        }
        int it = 0;
        while (it < rootFeatures.size()) {
            FeatureEntry[] imports;
            FeatureEntry[] entries;
            BuildTimeFeature toAnalyse = null;
            try {
                toAnalyse = (BuildTimeFeature)((Object)rootFeatures.get(it++));
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            FeatureEntry[] includedRefs = toAnalyse.getIncludedFeatureReferences();
            int i = 0;
            while (i < includedRefs.length) {
                String featureId = includedRefs[i].getId();
                BuildTimeFeature nested = this.findFeature(featureId, includedRefs[i].getVersion(), false);
                if (nested != null) {
                    rootFeatures.add(nested);
                } else {
                    Properties props = AbstractScriptGenerator.readProperties(toAnalyse.getRootLocation(), "build.properties", 0);
                    boolean doSourceFeatureGeneration = props.containsKey("generate.feature@" + featureId);
                    if (doSourceFeatureGeneration) {
                        String[] extraEntries = Utils.getArrayFromString(props.getProperty("generate.feature@" + featureId));
                        int j = 1;
                        while (j < extraEntries.length) {
                            Map<String, Object> items = Utils.parseExtraBundlesString(extraEntries[j], true);
                            String id = (String)items.get("id");
                            Version version = (Version)items.get("version");
                            if (extraEntries[j].startsWith("feature@")) {
                                FeatureEntry added = new FeatureEntry(id, version.toString(), false);
                                FeatureEntry[] expanded = new FeatureEntry[includedRefs.length + 1];
                                System.arraycopy(includedRefs, 0, expanded, 0, includedRefs.length);
                                expanded[includedRefs.length] = added;
                                includedRefs = expanded;
                            } else if (extraEntries[j].startsWith("plugin@")) {
                                VersionRange range = new VersionRange(version, true, version.equals((Object)Version.emptyVersion) ? null : version, true);
                                allPlugins.add(new ReachablePlugin(id, range));
                            }
                            ++j;
                        }
                    } else {
                        String message = NLS.bind((String)Messages.exception_missingFeature, (Object)featureId);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
                    }
                }
                ++i;
            }
            FeatureEntry[] featureEntryArray = entries = toAnalyse.getPluginEntries();
            int n = entries.length;
            int nested = 0;
            while (nested < n) {
                FeatureEntry entry = featureEntryArray[nested];
                allPlugins.add(new ReachablePlugin(entry));
                ++nested;
            }
            FeatureEntry[] featureEntryArray2 = imports = toAnalyse.getImports();
            int n2 = imports.length;
            n = 0;
            while (n < n2) {
                FeatureEntry import1 = featureEntryArray2[n];
                if (!import1.isPlugin()) {
                    rootFeatures.add(this.findFeature(import1.getId(), Utils.createVersionRange(import1), true));
                } else {
                    allPlugins.add(new ReachablePlugin(import1));
                }
                ++n;
            }
        }
        return allPlugins;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public void setRootFeaturesForFilter(List<String> rootFeaturesForFilter) {
        this.rootFeaturesForFilter = rootFeaturesForFilter;
    }

    public void setRootPluginsForFiler(List<String> rootPluginsForFiler) {
        this.rootPluginsForFiler = rootPluginsForFiler;
    }

    public FeatureReference[] getFeatureReferences() {
        return this.getRawFeatureReferences();
    }

    public FeatureReference[] getRawFeatureReferences() {
        if (this.featureReferences == null || this.featureReferences.size() == 0) {
            return new FeatureReference[0];
        }
        return this.featureReferences.toArray(new FeatureReference[this.featureReferences.size()]);
    }

    public void addPluginEntry(FeatureEntry pluginEntry) {
    }

    public Feature createFeature(URL url) throws CoreException {
        BuildTimeFeature feature = this.featureURLCache.get(url);
        if (feature != null) {
            return feature;
        }
        feature = this.factory.createFeature(url, this);
        feature.setFeatureContentProvider(this.getSiteContentProvider());
        this.featureURLCache.put(url, feature);
        if (this.featureCache.containsKey(feature.getId())) {
            Set<BuildTimeFeature> set = this.featureCache.get(feature.getId());
            set.add(feature);
        } else {
            TreeSet<Feature> set = new TreeSet<Feature>(this.featureComparator);
            set.add(feature);
            this.featureCache.put(feature.getId(), set);
        }
        return feature;
    }

    public BuildTimeSiteContentProvider getSiteContentProvider() {
        return this.contentProvider;
    }

    public void setSiteContentProvider(BuildTimeSiteContentProvider siteContentProvider) {
        this.contentProvider = siteContentProvider;
    }

    public void setEESources(String[] eeSources) {
        this.eeSources = eeSources;
    }
}

