/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorBinding;
import org.eclipse.acceleo.query.ast.ErrorCall;
import org.eclipse.acceleo.query.ast.ErrorConditional;
import org.eclipse.acceleo.query.ast.ErrorEClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorEnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorStringLiteral;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorVariableDeclaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.CompletionServices;
import org.eclipse.acceleo.query.runtime.impl.completion.TextCompletionProposal;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SetType;

public class AstCompletor
extends AstSwitch<List<ICompletionProposal>> {
    private static final String SPACE = " ";
    private final CompletionServices services;
    private Map<String, Set<IType>> variableTypes;
    private IValidationResult validationResult;

    public AstCompletor(CompletionServices services) {
        this.services = services;
    }

    public List<ICompletionProposal> getProposals(Map<String, Set<IType>> variableTypes, IValidationResult validationRes) {
        List<ICompletionProposal> result;
        this.validationResult = validationRes;
        this.variableTypes = variableTypes;
        Error errorToComplete = validationRes.getErrorToComplete();
        if (errorToComplete != null) {
            this.completeVariablesNames(errorToComplete);
            result = (List<ICompletionProposal>)this.doSwitch(errorToComplete);
        } else {
            Set<IType> possibleTypes = this.validationResult.getPossibleTypes(this.validationResult.getAstResult().getAst());
            result = this.getExpressionTextFollows(possibleTypes);
        }
        return result;
    }

    private void completeVariablesNames(Expression exp) {
        Expression current = exp;
        while (current != null) {
            if (current instanceof Let) {
                Let let = (Let)current;
                for (Binding binding : let.getBindings()) {
                    if (binding.getName() == null) continue;
                    this.variableTypes.put(binding.getName(), AQLUtils.getTypes(this.services.getQueryEnvironment(), binding.getType()));
                }
            } else if (current instanceof Lambda) {
                Lambda lambda = (Lambda)current;
                for (VariableDeclaration declaration : lambda.getParameters()) {
                    if (declaration.getName() == null) continue;
                    Set<IType> possibleTypes = this.validationResult.getPossibleTypes(declaration.getExpression());
                    this.variableTypes.put(declaration.getName(), possibleTypes);
                }
            }
            current = current.eContainer() instanceof Expression ? (Expression)current.eContainer() : null;
        }
    }

    @Override
    public List<ICompletionProposal> caseErrorExpression(ErrorExpression object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.addAll(this.getExpressionProposals());
        return result;
    }

    private List<ICompletionProposal> getExpressionProposals() {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.addAll(this.getExpressionTextPrefixes());
        result.addAll(this.services.getVariableProposals(this.variableTypes));
        result.addAll(this.services.getEClassifierProposals());
        result.addAll(this.services.getEEnumLiteralProposals());
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorTypeLiteral(ErrorTypeLiteral object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.add(new TextCompletionProposal("String", 0));
        result.add(new TextCompletionProposal("Integer", 0));
        result.add(new TextCompletionProposal("Real", 0));
        result.add(new TextCompletionProposal("Boolean", 0));
        result.add(new TextCompletionProposal("Sequence()", 1));
        result.add(new TextCompletionProposal("OrderedSet()", 1));
        result.add(new TextCompletionProposal("{}", 1));
        result.addAll(this.getEClassifierCompletion(null, null, null));
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorEClassifierTypeLiteral(ErrorEClassifierTypeLiteral object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (object.getEPackageName() != null && object.eContainer() instanceof ErrorCall && ((ErrorCall)object.eContainer()).isMissingEndParenthesis()) {
            result.add(new TextCompletionProposal("String", 0));
            result.add(new TextCompletionProposal("Integer", 0));
            result.add(new TextCompletionProposal("Real", 0));
            result.add(new TextCompletionProposal("Boolean", 0));
            result.add(new TextCompletionProposal("Sequence()", 1));
            result.add(new TextCompletionProposal("OrderedSet()", 1));
            result.add(new TextCompletionProposal("{}", 1));
        }
        result.addAll(this.getEClassifierCompletion(object.getEPackageName(), object.getEClassifierName(), null));
        return result;
    }

    protected List<ICompletionProposal> getEClassifierCompletion(String ePackageName, String eClassifierName, String eEnumLiteralName) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (ePackageName == null) {
            result.addAll(this.services.getEClassifierProposals());
            result.addAll(this.services.getEEnumLiteralProposals());
        } else if (eClassifierName == null) {
            result.addAll(this.services.getEClassifierProposals(ePackageName));
            result.addAll(this.services.getEEnumLiteralProposals(ePackageName));
        } else if (eEnumLiteralName == null) {
            result.addAll(this.services.getEEnumLiteralProposals(ePackageName, eClassifierName));
        }
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorEnumLiteral(ErrorEnumLiteral object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.addAll(this.services.getEEnumLiteralProposals(object.getEPackageName(), object.getEEnumName()));
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorCall(ErrorCall object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (!object.isMissingEndParenthesis()) {
            LinkedHashSet<IType> collectionTypes = new LinkedHashSet<IType>();
            Set<IType> possibleReceiverTypes = this.validationResult.getPossibleTypes((Expression)object.getArguments().get(0));
            if (possibleReceiverTypes.isEmpty()) {
                collectionTypes.add(new SetType(this.services.getQueryEnvironment(), new NothingType("Argument collection will be empty for call to " + object.getServiceName())));
            } else {
                for (IType type : possibleReceiverTypes) {
                    collectionTypes.add(this.getCollectionTypes(object, type));
                }
            }
            result.addAll(this.services.getServiceProposals(collectionTypes, object.getType()));
        } else if (object.getArguments().size() == 1) {
            result.addAll(this.getExpressionProposals());
            result.addAll(this.services.getVariableDeclarationProposals(this.validationResult.getPossibleTypes((Expression)object.getArguments().get(0))));
        } else {
            Expression firstArg = (Expression)object.getArguments().get(1);
            if (firstArg instanceof Lambda) {
                result.add(new TextCompletionProposal(", ", 0));
                result.add(new TextCompletionProposal(")", 0));
                Lambda lambda = (Lambda)firstArg;
                result.addAll(this.getExpressionTextFollows(this.validationResult.getPossibleTypes(lambda.getExpression())));
            } else if (!object.getArguments().isEmpty()) {
                Expression lastArgument = (Expression)object.getArguments().get(object.getArguments().size() - 1);
                if (lastArgument instanceof VarRef && !this.variableTypes.keySet().contains(((VarRef)lastArgument).getVariableName())) {
                    result.add(new TextCompletionProposal(": ", 0));
                    result.add(new TextCompletionProposal("| ", 0));
                } else {
                    result.add(new TextCompletionProposal(", ", 0));
                    result.add(new TextCompletionProposal(")", 0));
                }
            }
        }
        return result;
    }

    private IType getCollectionTypes(ErrorCall errorCall, IType type) {
        IType result = type instanceof ICollectionType ? (errorCall.getType() == CallType.CALLORAPPLY ? ((ICollectionType)type).getCollectionType() : type) : (errorCall.getType() == CallType.COLLECTIONCALL ? new SetType(this.services.getQueryEnvironment(), type) : type);
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorVariableDeclaration(ErrorVariableDeclaration object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (object.getName() == null) {
            result.addAll(this.services.getVariableDeclarationProposals(this.validationResult.getPossibleTypes(object.getExpression())));
        } else if (object.getType() == null) {
            result.add(new TextCompletionProposal(": ", 0));
            result.add(new TextCompletionProposal("| ", 0));
        } else if (object.getType() instanceof ErrorTypeLiteral) {
            result.addAll((Collection)this.doSwitch(object.getType()));
        } else {
            result.add(new TextCompletionProposal("| ", 0));
        }
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorStringLiteral(ErrorStringLiteral object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorBinding(ErrorBinding object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (object.getName() != null) {
            if (object.getType() instanceof ErrorTypeLiteral) {
                result.addAll((Collection)this.doSwitch(object.getType()));
            } else {
                if (object.getType() == null) {
                    result.add(new TextCompletionProposal(": ", 0));
                }
                if (object.getValue() == null) {
                    result.add(new TextCompletionProposal("= ", 0));
                }
                if (object.getValue() instanceof ErrorExpression) {
                    result.addAll((Collection)this.doSwitch(object.getValue()));
                }
            }
        }
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorConditional(ErrorConditional object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (object.getFalseBranch() != null) {
            Set<IType> possibleTypes = this.validationResult.getPossibleTypes(object.getFalseBranch());
            result.addAll(this.getExpressionTextFollows(possibleTypes));
            result.add(new TextCompletionProposal("endif ", 0));
        } else if (object.getTrueBranch() != null) {
            Set<IType> possibleTypes = this.validationResult.getPossibleTypes(object.getTrueBranch());
            result.addAll(this.getExpressionTextFollows(possibleTypes));
            result.add(new TextCompletionProposal("else ", 0));
        } else if (object.getPredicate() != null) {
            Set<IType> possibleTypes = this.validationResult.getPossibleTypes(object.getPredicate());
            result.addAll(this.getExpressionTextFollows(possibleTypes));
            result.add(new TextCompletionProposal("then ", 0));
        }
        return result;
    }

    public List<ICompletionProposal> getExpressionTextPrefixes() {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.add(new TextCompletionProposal("not ", 0));
        result.add(new TextCompletionProposal("- ", 0));
        result.add(new TextCompletionProposal("()", 1));
        result.add(new TextCompletionProposal("true", 0));
        result.add(new TextCompletionProposal("false", 0));
        result.add(new TextCompletionProposal("null", 0));
        result.add(new TextCompletionProposal("{}", 1));
        result.add(new TextCompletionProposal("String", 0));
        result.add(new TextCompletionProposal("Integer", 0));
        result.add(new TextCompletionProposal("Real", 0));
        result.add(new TextCompletionProposal("Boolean", 0));
        result.add(new TextCompletionProposal("Sequence{}", 1));
        result.add(new TextCompletionProposal("OrderedSet{}", 1));
        result.add(new TextCompletionProposal("let ", 0));
        result.add(new TextCompletionProposal("if ", 0));
        return result;
    }

    private List<ICompletionProposal> getExpressionTextFollows(Set<IType> possibleTypes) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        List<ICompletionProposal> servicesProposal = this.services.getServiceProposals(possibleTypes, null);
        HashSet<String> serviceNames = new HashSet<String>();
        for (ICompletionProposal proposal : servicesProposal) {
            if (!(proposal instanceof IServiceCompletionProposal)) continue;
            serviceNames.add(((IServiceCompletionProposal)proposal).getObject().getName());
        }
        if (serviceNames.contains("add")) {
            result.add(new TextCompletionProposal("+ ", 0));
        }
        if (serviceNames.contains("sub")) {
            result.add(new TextCompletionProposal("- ", 0));
        }
        if (serviceNames.contains("lessThanEqual")) {
            result.add(new TextCompletionProposal("<= ", 0));
        }
        if (serviceNames.contains("greaterThanEqual")) {
            result.add(new TextCompletionProposal(">= ", 0));
        }
        if (serviceNames.contains("differs")) {
            result.add(new TextCompletionProposal("<> ", 0));
        }
        if (serviceNames.contains("equals")) {
            result.add(new TextCompletionProposal("= ", 0));
        }
        if (serviceNames.contains("lessThan")) {
            result.add(new TextCompletionProposal("< ", 0));
        }
        if (serviceNames.contains("greaterThan")) {
            result.add(new TextCompletionProposal("> ", 0));
        }
        if (serviceNames.contains("mult")) {
            result.add(new TextCompletionProposal("* ", 0));
        }
        if (serviceNames.contains("divOp")) {
            result.add(new TextCompletionProposal("/ ", 0));
        }
        if (serviceNames.contains("and")) {
            result.add(new TextCompletionProposal("and ", 0));
        }
        if (serviceNames.contains("or")) {
            result.add(new TextCompletionProposal("or ", 0));
        }
        if (serviceNames.contains("xor")) {
            result.add(new TextCompletionProposal("xor ", 0));
        }
        if (serviceNames.contains("implies")) {
            result.add(new TextCompletionProposal("implies ", 0));
        }
        return result;
    }
}

