/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.ConnectionLayoutTagger;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.SetPositionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public abstract class AbstractChangeContainerBoundsCommand
extends Command
implements ConnectionLayoutTagger,
ScopedCommand {
    private final int dx;
    private final int dy;
    private final double oldWidth;
    private final double oldHeight;
    private final double newWidth;
    private final double newHeight;
    private final PositionableElement target;
    private CompoundCommand updatePositions;

    protected AbstractChangeContainerBoundsCommand(PositionableElement target, int dx, int dy, int dw, int dh, double oldWidth, double oldHeight) {
        this.target = Objects.requireNonNull(target);
        this.dx = dx;
        this.dy = dy;
        this.oldWidth = oldWidth;
        this.oldHeight = oldHeight;
        this.newWidth = AbstractChangeContainerBoundsCommand.calcNewSize(dx, dw, oldWidth);
        this.newHeight = AbstractChangeContainerBoundsCommand.calcNewSize(dy, dh, oldHeight);
    }

    private static double calcNewSize(int deltaPos, int deltaSize, double oldSize) {
        if (deltaSize == 0) {
            return oldSize;
        }
        if (deltaPos == 0) {
            --deltaSize;
        }
        return CoordinateConverter.INSTANCE.screenToIEC61499(CoordinateConverter.INSTANCE.iec61499ToScreen(oldSize) + deltaSize);
    }

    public void execute() {
        this.updatePositions = this.createSetPosCommand();
        this.updateSize(this.newWidth, this.newHeight);
        if (this.updatePositions != null) {
            this.updatePositions.execute();
        }
    }

    public void undo() {
        if (this.updatePositions != null) {
            this.updatePositions.undo();
        }
        this.updateSize(this.oldWidth, this.oldHeight);
    }

    public void redo() {
        if (this.updatePositions != null) {
            this.updatePositions.redo();
        }
        this.updateSize(this.newWidth, this.newHeight);
    }

    public PositionableElement getTarget() {
        return this.target;
    }

    private CompoundCommand createSetPosCommand() {
        if (this.dx != 0 || this.dy != 0) {
            CompoundCommand cmd = new CompoundCommand();
            cmd.add((Command)new SetPositionCommand(this.target, this.dx, this.dy));
            this.getChildren().stream().filter(el -> !el.isInGroup() || this.target.equals(el.getGroup())).forEach(el -> cmd.add((Command)new SetPositionCommand((PositionableElement)el, -this.dx, -this.dy)));
            return cmd;
        }
        return null;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.target);
    }

    protected abstract void updateSize(double var1, double var3);

    protected abstract List<FBNetworkElement> getChildren();
}

