/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.HierarchyPackage;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.util.HierarchyResourceFactoryImpl;
import org.eclipse.fordiac.ide.hierarchymanager.ui.view.PlantHierarchyView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public final class HierarchyManagerRefactoringUtil {
    private static final List<String> ALLOWED_FILE_EXTENSIONS = List.of("sys", "sub");

    /*
     * Enabled aggressive block sorting
     */
    public static List<IFile> getFilesFromResource(IResource resource) throws CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (resource.getFileExtension() != null && ALLOWED_FILE_EXTENSIONS.contains(resource.getFileExtension().toLowerCase())) {
                files.add(file);
                return files;
            }
        }
        if (!(resource instanceof IFolder)) return files;
        IFolder folder = (IFolder)resource;
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            files.addAll(HierarchyManagerRefactoringUtil.getFilesFromResource(member));
            ++n2;
        }
        return files;
    }

    public static RootLevel getPlantHierarchy(IProject project) {
        Object object;
        PlantHierarchyView phView = (PlantHierarchyView)((Object)Display.getDefault().syncCall(() -> {
            IViewPart iViewPart;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null && (iViewPart = page.findView("org.eclipse.fordiac.ide.hierarchymanager.view")) instanceof PlantHierarchyView) {
                PlantHierarchyView view = (PlantHierarchyView)iViewPart;
                return view;
            }
            return null;
        }));
        if (phView != null && project.equals((Object)phView.getCurrentProject()) && (object = phView.getCommonViewer().getInput()) instanceof RootLevel) {
            RootLevel rootLevel = (RootLevel)object;
            return rootLevel;
        }
        return HierarchyManagerRefactoringUtil.loadPlantHierarchy(project);
    }

    public static boolean plantHierachyExists(IProject project) {
        return project.getFile(PlantHierarchyView.PLANT_HIERARCHY_FILE_NAME).exists();
    }

    public static String getOldPath(IResource element) {
        return element.getProjectRelativePath().toPortableString();
    }

    public static String getNewPath(IResource element, String newName) {
        return element.getProjectRelativePath().removeLastSegments(1).append(newName).toPortableString();
    }

    public static String getDestinationPath(IResource element, IFolder destination) {
        return destination.getProjectRelativePath().append(element.getName()).toPortableString();
    }

    public static RootLevel loadPlantHierarchy(IProject project) {
        HashMap<String, Object> loadOptions = new HashMap<String, Object>();
        ResourceSetImpl hierarchyResouceSet = new ResourceSetImpl();
        hierarchyResouceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("HIER", new HierarchyResourceFactoryImpl());
        hierarchyResouceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("HIER".toLowerCase(), new HierarchyResourceFactoryImpl());
        loadOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
        XMLMapImpl map = new XMLMapImpl();
        map.setNoNamespacePackage((EPackage)HierarchyPackage.eINSTANCE);
        loadOptions.put("XML_MAP", map);
        hierarchyResouceSet.getLoadOptions().put("XML_MAP", map);
        return (RootLevel)PlantHierarchyView.loadHierachyForProject(project, (ResourceSet)hierarchyResouceSet, loadOptions);
    }

    private HierarchyManagerRefactoringUtil() {
        throw new UnsupportedOperationException("Utility class can not be instantiated!");
    }
}

