/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.lang.runtime.SwitchBootstraps;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyDurationType;
import org.eclipse.fordiac.ide.model.data.AnyNumType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.data.ByteType;
import org.eclipse.fordiac.ide.model.data.CharType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DateAndTimeType;
import org.eclipse.fordiac.ide.model.data.DateType;
import org.eclipse.fordiac.ide.model.data.DwordType;
import org.eclipse.fordiac.ide.model.data.EnumeratedType;
import org.eclipse.fordiac.ide.model.data.LdateType;
import org.eclipse.fordiac.ide.model.data.LdtType;
import org.eclipse.fordiac.ide.model.data.LtodType;
import org.eclipse.fordiac.ide.model.data.LwordType;
import org.eclipse.fordiac.ide.model.data.StringType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.data.TimeOfDayType;
import org.eclipse.fordiac.ide.model.data.WcharType;
import org.eclipse.fordiac.ide.model.data.WordType;
import org.eclipse.fordiac.ide.model.data.WstringType;
import org.eclipse.fordiac.ide.model.datatype.helper.TypeDeclarationParser;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.value.ArrayValueConverter;
import org.eclipse.fordiac.ide.model.value.BoolValueConverter;
import org.eclipse.fordiac.ide.model.value.DateAndTimeValueConverter;
import org.eclipse.fordiac.ide.model.value.DateValueConverter;
import org.eclipse.fordiac.ide.model.value.EnumValueConverter;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;
import org.eclipse.fordiac.ide.model.value.StringValueConverter;
import org.eclipse.fordiac.ide.model.value.StructValueConverter;
import org.eclipse.fordiac.ide.model.value.TimeOfDayValueConverter;
import org.eclipse.fordiac.ide.model.value.TimeValueConverter;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;
import org.eclipse.fordiac.ide.model.value.ValueConverter;
import org.eclipse.fordiac.ide.model.value.WStringValueConverter;

public final class ValueConverterFactory {
    public static ValueConverter<?> createValueConverter(DataType type) {
        DataType dataType = type;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolType.class, AnyNumType.class, ByteType.class, WordType.class, DwordType.class, LwordType.class, AnyDurationType.class, CharType.class, StringType.class, WcharType.class, WstringType.class, DateType.class, LdateType.class, TimeOfDayType.class, LtodType.class, DateAndTimeType.class, LdtType.class, ArrayType.class, StructuredType.class, EnumeratedType.class}, (Object)dataType, 0)) {
            case 0 -> {
                BoolType unused = (BoolType)dataType;
                yield BoolValueConverter.INSTANCE;
            }
            case 1 -> {
                AnyNumType unused = (AnyNumType)dataType;
                yield NumericValueConverter.INSTANCE;
            }
            case 2 -> {
                ByteType unused = (ByteType)dataType;
                yield NumericValueConverter.INSTANCE_BYTE;
            }
            case 3 -> {
                WordType unused = (WordType)dataType;
                yield NumericValueConverter.INSTANCE_WORD;
            }
            case 4 -> {
                DwordType unused = (DwordType)dataType;
                yield NumericValueConverter.INSTANCE_DWORD;
            }
            case 5 -> {
                LwordType unused = (LwordType)dataType;
                yield NumericValueConverter.INSTANCE_LWORD;
            }
            case 6 -> {
                AnyDurationType unused = (AnyDurationType)dataType;
                yield TimeValueConverter.INSTANCE;
            }
            case 7 -> {
                CharType unused = (CharType)dataType;
                yield StringValueConverter.INSTANCE;
            }
            case 8 -> {
                StringType unused = (StringType)dataType;
                yield StringValueConverter.INSTANCE;
            }
            case 9 -> {
                WcharType unused = (WcharType)dataType;
                yield WStringValueConverter.INSTANCE;
            }
            case 10 -> {
                WstringType unused = (WstringType)dataType;
                yield WStringValueConverter.INSTANCE;
            }
            case 11 -> {
                DateType unused = (DateType)dataType;
                yield DateValueConverter.INSTANCE;
            }
            case 12 -> {
                LdateType unused = (LdateType)dataType;
                yield DateValueConverter.INSTANCE;
            }
            case 13 -> {
                TimeOfDayType unused = (TimeOfDayType)dataType;
                yield TimeOfDayValueConverter.INSTANCE;
            }
            case 14 -> {
                LtodType unused = (LtodType)dataType;
                yield TimeOfDayValueConverter.INSTANCE;
            }
            case 15 -> {
                DateAndTimeType unused = (DateAndTimeType)dataType;
                yield DateAndTimeValueConverter.INSTANCE;
            }
            case 16 -> {
                LdtType unused = (LdtType)dataType;
                yield DateAndTimeValueConverter.INSTANCE;
            }
            case 17 -> {
                ArrayType arrayType = (ArrayType)dataType;
                yield new ArrayValueConverter<Object>(new TypedValueConverter(ValueConverterFactory.getElementType(arrayType), ValueConverterFactory.getDataTypeLibrary(arrayType)));
            }
            case 18 -> {
                StructuredType structuredType = (StructuredType)dataType;
                yield new StructValueConverter(name -> new TypedValueConverter(ValueConverterFactory.getMemberType(structuredType, name), ValueConverterFactory.getDataTypeLibrary(structuredType)));
            }
            case 19 -> {
                EnumeratedType enumeratedType = (EnumeratedType)dataType;
                yield new EnumValueConverter(enumeratedType);
            }
            default -> null;
        };
    }

    private static DataType getElementType(ArrayType type) {
        if (type.getSubranges().size() > 1) {
            ArrayType result = (ArrayType)EcoreUtil.copy((EObject)type);
            result.getSubranges().removeFirst();
            return result;
        }
        return type.getBaseType();
    }

    private static DataType getMemberType(StructuredType type, String name) {
        VarDeclaration member = type.getMemberVariables().stream().filter(v -> name.equals(v.getName())).findFirst().orElseThrow();
        if (member.isArray()) {
            return TypeDeclarationParser.parseTypeDeclaration(member.getType(), member.getArraySize().getValue());
        }
        return member.getType();
    }

    private static DataTypeLibrary getDataTypeLibrary(DataType type) {
        return type.getTypeLibrary() != null ? type.getTypeLibrary().getDataTypeLibrary() : null;
    }

    private ValueConverterFactory() {
        throw new IllegalStateException("Utility class should not be instantiated!");
    }
}

