/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import java.util.BitSet;
import java.util.Random;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.lns.neighbors.IntNeighbor;
import org.chocosolver.solver.variables.IntVar;

public class RandomNeighborhood
extends IntNeighbor {
    protected final int n;
    private final Random rd;
    private double nbFixedVariables = 0.0;
    private int nbCall;
    protected int limit;
    protected final int level;
    protected BitSet fragment;

    public RandomNeighborhood(IntVar[] vars, int level, long seed) {
        super(vars);
        this.n = vars.length;
        this.level = level;
        this.rd = new Random(seed);
        this.fragment = new BitSet(this.n);
    }

    @Override
    public void recordSolution() {
        super.recordSolution();
        this.nbFixedVariables = 2.0 * (double)this.n / 3.0 + 1.0;
        this.nbCall = 0;
        this.limit = 200;
    }

    @Override
    public void loadFromSolution(Solution solution) {
        super.loadFromSolution(solution);
        this.nbFixedVariables = 2.0 * (double)this.n / 3.0 + 1.0;
        this.nbCall = 0;
        this.limit = 200;
    }

    @Override
    public void fixSomeVariables() throws ContradictionException {
        ++this.nbCall;
        this.restrictLess();
        this.fragment.set(0, this.n);
        int i = 0;
        while ((double)i < this.nbFixedVariables - 1.0 && this.fragment.cardinality() > 0) {
            int id = this.selectVariable();
            if (this.variables[id].contains(this.values[id])) {
                this.freeze(id);
            }
            this.fragment.clear(id);
            ++i;
        }
    }

    private int selectVariable() {
        int id = this.fragment.nextSetBit(0);
        for (int cc = this.rd.nextInt(this.fragment.cardinality()); id >= 0 && cc > 0; --cc) {
            id = this.fragment.nextSetBit(id + 1);
        }
        return id;
    }

    @Override
    public void restrictLess() {
        if (this.nbCall > this.limit) {
            this.limit = this.nbCall + this.level;
            this.nbFixedVariables = this.rd.nextDouble() * (double)this.n;
        }
    }
}

