## ----include=FALSE------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  error = TRUE
)

## ----setup--------------------------------------------------------------------
library(SeaSondeR)

## -----------------------------------------------------------------------------
# Set sample file paths
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")

apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")

# Read the antenna pattern file to create a SeaSondeRAPM object
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)

# Create a SeaSondeRCS object from a spectral file
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)

# Compute first-order regions and run the MUSIC algorithm if needed:

cs_obj <- seasonder_computeFORs(cs_obj, FOR_control = list(nsm = 2, fdown = 10^(10/10), flim = 10^(20/10),
                                                            noisefact = 10^(6/10), currmax = 2,
                                                            reject_distant_bragg = TRUE, reject_noise_ionospheric = FALSE,
                                                            reject_noise_ionospheric_threshold = 0))
 cs_obj <- seasonder_runMUSICInFOR(cs_obj)

# Define a land mask (AngSeg) to remove onshore data
AngSeg <- purrr::list_c(lapply(45:61, function(i) list(c(i, 313, 360), c(i, 0, 31))))

temp_file <- tempfile(fileext = ".ruv")

# Export the radial metrics in LLUV format
radial_metrics <- seasonder_exportLLUVRadialMetrics(cs_obj,
                                                    LLUV_path = temp_file,
                                                    AngSeg = AngSeg)

# Display the first few rows of the exported radial metrics
head(radial_metrics)

