/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.preorder.ContinuousExtensionDelegate;
import dr.inference.model.MatrixParameterInterface;
import dr.math.matrixAlgebra.missingData.MissingOps;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public interface ModelExtensionProvider
extends ContinuousTraitPartialsProvider {
    public ContinuousExtensionDelegate getExtensionDelegate(ContinuousDataLikelihoodDelegate var1, TreeTrait var2, Tree var3);

    public static interface NormalExtensionProvider
    extends ModelExtensionProvider {
        public boolean diagonalVariance();

        public DenseMatrix64F getExtensionVariance();

        public DenseMatrix64F getExtensionVariance(NodeRef var1);

        public MatrixParameterInterface getExtensionPrecision();

        public void chainRuleWrtVariance(double[] var1, NodeRef var2);

        @Override
        default public void updateTipDataGradient(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, NodeRef nodeRef, int n, int n2) {
            NormalExtensionProvider.extendTipDataGradient(this, denseMatrix64F, denseMatrix64F2, nodeRef, n, n2);
        }

        public static void extendTipDataGradient(NormalExtensionProvider normalExtensionProvider, DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, NodeRef nodeRef, int n, int n2) {
            if (n != 0 || n2 != normalExtensionProvider.getTraitDimension()) {
                throw new RuntimeException("not implemented for subset of model.");
            }
            DenseMatrix64F denseMatrix64F3 = normalExtensionProvider.getExtensionVariance(nodeRef);
            CommonOps.addEquals(denseMatrix64F3, denseMatrix64F2);
            MissingOps.safeInvert2(denseMatrix64F3, denseMatrix64F, false);
        }

        @Override
        default public boolean needToUpdateTipDataGradient(int n, int n2) {
            return true;
        }
    }
}

