/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.siteratemodel;

import dr.evomodel.siteratemodel.SiteRateDelegate;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.List;

public class FreeRateDelegate
extends AbstractModel
implements SiteRateDelegate,
Citable {
    private final Parameter rateParameter;
    private final Parameter weightParameter;
    private final int categoryCount;
    public static final Citation CITATION_YANG94 = new Citation(new Author[]{new Author("", "")}, "", 1994, "J. Mol. Evol.", 39, 306, 314, Citation.Status.PUBLISHED);

    public FreeRateDelegate(String string, int n, Parameter parameter, Parameter parameter2) {
        super(string);
        this.categoryCount = n;
        this.rateParameter = parameter;
        this.addVariable(this.rateParameter);
        this.weightParameter = parameter2;
        if (this.weightParameter.getDimension() == 1) {
            this.weightParameter.setDimension(n);
        } else if (this.weightParameter.getDimension() != n) {
            throw new IllegalArgumentException("Weight parameter should have have an initial dimension of one or category count");
        }
        this.addVariable(this.weightParameter);
        this.weightParameter.addBounds(new Parameter.DefaultBounds(1.0, 0.0, n));
    }

    @Override
    public int getCategoryCount() {
        return this.categoryCount;
    }

    @Override
    public void getCategories(double[] dArray, double[] dArray2) {
        assert (dArray != null && dArray.length == this.categoryCount);
        assert (dArray2 != null && dArray2.length == this.categoryCount);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.categoryCount; ++i) {
            dArray[i] = this.rateParameter.getParameterValue(i);
            dArray2[i] = this.weightParameter.getParameterValue(i);
            d += dArray[i] * dArray2[i];
            d2 += dArray2[i];
        }
        assert (Math.abs(d - 1.0) < 1.0E-10);
        assert (Math.abs(d2 - 1.0) < 1.0E-10);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.weightParameter) {
            this.rateParameter.fireParameterChangedEvent();
        }
        this.listenerHelper.fireModelChanged(this, variable, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Discrete free-rate heterogeneity model";
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        return arrayList;
    }

    public static void normalize(double[] dArray, double[] dArray2) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
            d2 += dArray2[n];
        }
        d /= (double)dArray.length;
        n = 0;
        while (n < dArray.length) {
            int n2 = n;
            dArray[n2] = dArray[n2] / d;
            int n3 = n++;
            dArray2[n3] = dArray2[n3] / d2;
        }
    }
}

