# glueDo News

## glueDo 0.1.0 - Initial Release

We are excited to announce the initial release of the **glueDo** R package! This package provides a set of convenient wrapper functions that allow you to pass expressive glue strings directly to common R functions, executing them with evaluated string content.

### Key Features

- Evaluate glue strings seamlessly within any environment
- Pass the evaluated strings to base R functions like `message()`, `print()`, `stop()`, `warning()`, `cat()`, and `writeLines()`
- General-purpose interface to run any custom function on evaluated glue strings
- Simplifies dynamic message construction, error reporting, and file writing

### Included Functions

- `glue_do()`  
  Core function that takes a glue string, evaluates it, and passes the result to any function.

- `glue_func()`  
  Execute a custom function with the evaluated glue string.

- `glue_stop()`  
  Evaluate a glue string and call `stop()` to raise an error with dynamic messages.

- `glue_print()`  
  Print the evaluated glue string.

- `glue_message()`  
  Send a message with evaluated dynamic content.

- `glue_warning()`  
  Raise a warning with dynamic text.

- `glue_cat()`  
  Concatenate and output the evaluated glue string similar to `cat()`.

- `glue_return()`  
  Evaluate and return the glue string (identity function).

- `glue_write()`  
  Write the evaluated glue string to a specified file with automatic connection handling.

### Example

```r
world <- "mars"
glue_message("HELLO {world}!")
# Prints: HELLO mars!
