/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.evolution.tree.Tree;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.TaxonEffectTraitDataModel;
import dr.inference.distribution.DistributionLikelihood;
import dr.inference.model.AbstractModel;
import dr.inference.model.AbstractVarianceProportionStatistic;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Parameter;
import dr.inference.model.TreeVarianceSums;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.math.matrixAlgebra.Matrix;
import dr.stats.DiscreteStatistics;

public class TaxonEffectVarianceProportionStatistic
extends AbstractVarianceProportionStatistic
implements VariableListener,
ModelListener {
    private final MultivariateDiffusionModel diffusionModel;
    private final DistributionLikelihood prior;
    private final TreeVarianceSums treeSums;
    private final Parameter effects;
    private Matrix diffusionVariance;
    private Matrix effectsVariance;
    private boolean treeKnown = false;
    private boolean varianceKnown = false;
    private static final boolean USE_POPULATION_VARIANCE = false;

    public TaxonEffectVarianceProportionStatistic(Tree tree, TreeDataLikelihood treeDataLikelihood, TaxonEffectTraitDataModel taxonEffectTraitDataModel, MultivariateDiffusionModel multivariateDiffusionModel, DistributionLikelihood distributionLikelihood, AbstractVarianceProportionStatistic.MatrixRatios matrixRatios) {
        super(tree, treeDataLikelihood, taxonEffectTraitDataModel, matrixRatios);
        this.diffusionModel = multivariateDiffusionModel;
        this.treeSums = new TreeVarianceSums(0.0, 0.0);
        this.effects = taxonEffectTraitDataModel.getEffects();
        this.diffusionVariance = null;
        this.effectsVariance = null;
        this.prior = distributionLikelihood;
        if (this.isTreeRandom.booleanValue()) {
            ((AbstractModel)((Object)tree)).addModelListener(this);
        }
        multivariateDiffusionModel.getPrecisionParameter().addParameterListener(this);
        this.effects.addParameterListener(this);
    }

    private Matrix getEffectsVariance() {
        double d = DiscreteStatistics.variance(this.effects.getParameterValues());
        return new Matrix(new double[][]{{d}});
    }

    @Override
    protected void updateVarianceComponents() {
        double d = this.tree.getExternalNodeCount();
        double d2 = this.treeSums.getDiagonalSum() / d - this.treeSums.getTotalSum() / (d * d);
        double d3 = 1.0;
        for (int i = 0; i < this.dimTrait; ++i) {
            this.diffusionComponent.set(i, i, d2 * this.diffusionVariance.component(i, i));
            this.samplingComponent.set(i, i, d3 * this.effectsVariance.component(i, i));
            for (int j = i + 1; j < this.dimTrait; ++j) {
                double d4 = d2 * this.diffusionVariance.component(i, j);
                double d5 = d3 * this.effectsVariance.component(i, j);
                this.diffusionComponent.set(i, j, d4);
                this.samplingComponent.set(i, j, d5);
                this.diffusionComponent.set(j, i, d4);
                this.samplingComponent.set(j, i, d5);
            }
        }
    }

    @Override
    protected boolean needToUpdate(int n) {
        boolean bl = false;
        if (!this.treeKnown) {
            this.updateTreeSums(this.treeSums);
            this.treeKnown = true;
            bl = true;
        }
        if (!this.varianceKnown) {
            this.effectsVariance = this.getEffectsVariance();
            this.diffusionVariance = new Matrix(this.diffusionModel.getPrecisionmatrix()).inverse();
            this.varianceKnown = true;
            bl = true;
        }
        return bl;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        assert (variable == this.effects || variable == this.diffusionModel.getPrecisionParameter());
        this.varianceKnown = false;
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
        assert (model == this.tree);
        if (!this.isTreeRandom.booleanValue()) {
            throw new IllegalStateException("Attempting to change a fixed tree");
        }
        this.treeKnown = false;
    }

    @Override
    public void modelRestored(Model model) {
    }
}

